% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggplot2_args.R
\name{ggplot2_args}
\alias{ggplot2_args}
\title{Creates \code{ggplot2_args} object}
\usage{
ggplot2_args(labs = list(), theme = list())
}
\arguments{
\item{labs}{(named \code{list})\cr
where all fields have to match \code{\link[ggplot2:labs]{ggplot2::labs()}} arguments.}

\item{theme}{(named \code{list})\cr
where all fields have to match \code{\link[ggplot2:theme]{ggplot2::theme()}} arguments.}
}
\value{
(\code{ggplot2_args}) object.
}
\description{
Constructor of \code{ggplot2_args} class of objects.
The \code{ggplot2_args} argument should be a part of every module which contains any \code{ggplot2} graphics.
The function arguments are validated to match their \code{ggplot2} equivalents.

For more details see the vignette: \code{vignette("custom-ggplot2-arguments", package = "teal.widgets")}.
}
\examples{
ggplot2_args(
  labs = list(title = "TITLE"),
  theme = list(title = ggplot2::element_text(size = 20))
)
}
\seealso{
\itemize{
\item \code{\link[=resolve_ggplot2_args]{resolve_ggplot2_args()}} to resolve multiple objects into one using pre-defined priorities.
\item \code{\link[=parse_ggplot2_args]{parse_ggplot2_args()}} to parse resolved list into list of calls.
}
}
