% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/format_data_extract.R
\name{format_data_extract}
\alias{format_data_extract}
\title{Formatting data extracts}
\usage{
format_data_extract(data_extract)
}
\arguments{
\item{data_extract}{\code{list} the list output of \code{data_extract_srv}.}
}
\value{
\code{character(1)} representation of the \code{data_extract} object.
}
\description{
Returns a human-readable string representation of an extracted \code{data_extract_spec} object.
}
\details{
This function formats the output of \code{\link{data_extract_srv}}.
See the example for more information.
}
\examples{
library(shiny)

simple_des <- data_extract_spec(
  dataname = "iris",
  filter = filter_spec(vars = "Petal.Length", choices = c("1.4", "1.5")),
  select = select_spec(choices = c("Petal.Length", "Species"))
)

ui <- bslib::page_fluid(
  data_extract_ui(
    id = "extract",
    label = "data extract ui",
    data_extract_spec = simple_des,
    is_single_dataset = TRUE
  ),
  verbatimTextOutput("formatted_extract")
)
server <- function(input, output, session) {
  extracted_input <- data_extract_srv(
    id = "extract",
    datasets = list(iris = iris),
    data_extract_spec = simple_des
  )
  output$formatted_extract <- renderPrint({
    cat(format_data_extract(extracted_input()))
  })
}

if (interactive()) {
  shinyApp(ui, server)
}
}
