% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predictive-power.R
\name{pred_power_test}
\alias{pred_power_test}
\alias{print.pred_power_test}
\alias{summary.pred_power_test}
\alias{tidy.pred_power_test}
\alias{glance.pred_power_test}
\title{Pfeffermann-Nathan Predictive Power Test (svyglm, K-fold CV, fold-mean option) (In production)}
\usage{
pred_power_test(
  model,
  kfold = TRUE,
  K = 5,
  est_split = 0.5,
  use_fold_means = TRUE,
  seed = NULL
)

\method{print}{pred_power_test}(x, ...)

\method{summary}{pred_power_test}(object, ...)

\method{tidy}{pred_power_test}(x, ...)

\method{glance}{pred_power_test}(x, ...)
}
\arguments{
\item{model}{A fitted \code{svyglm} with \code{family = gaussian(identity)}.}

\item{kfold}{Logical; if TRUE, use K-fold cross-validation (default TRUE).}

\item{K}{Integer number of folds (default 5).}

\item{est_split}{Proportion for estimation set if \code{kfold = FALSE} (default 0.5).}

\item{use_fold_means}{Logical; if TRUE (default), compute one \eqn{D} per fold
as the mean of within-fold \eqn{D_i}, then form \eqn{Z} using the \eqn{K} fold
means. This stabilizes the test by reducing dependence noted in Wang (2023).}

\item{seed}{Optional integer seed for reproducibility.}

\item{x}{An object of class pred_power_test}

\item{...}{Additional arguments passed to methods}

\item{object}{An object of class pred_power_test}
}
\value{
An object of class \code{"pred_power_test"} with fields:
  \item{statistic}{Z statistic}
  \item{p.value}{Two-sided p-value}
  \item{mean_diff}{Mean of \eqn{D} (fold mean if \code{use_fold_means = TRUE})}
  \item{n_val}{Count of observations used in Z (\eqn{K} if \code{use_fold_means = TRUE}, else total validation n)}
  \item{K}{Number of folds (if \code{kfold = TRUE})}
  \item{method}{Description string}
  \item{call}{Matched call}
}
\description{
Implements the predictive power test following Wang et al. (2023, Sec. 2.2):
split observations into estimation and validation sets; fit unweighted and weighted
linear regressions on the estimation set; compute validation squared-error differences
\eqn{D_i = (y_i - \hat y_{u,i})^2 - (y_i - \hat y_{w,i})^2}; test \eqn{H_0: E[D_i] = 0}
with \eqn{Z = \bar D / (s_D / \sqrt{n_V})}. Supports K-fold CV (default) and a
"fold-mean" option to reduce dependence among errors by using per-fold means as
the test observations.
}
\keyword{internal}
