% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ui.R
\name{sd_ui}
\alias{sd_ui}
\title{Create the UI for a surveydown survey}
\usage{
sd_ui()
}
\value{
A 'shiny' UI object
}
\description{
This function creates the user interface for a surveydown survey,
including necessary CSS and JavaScript files, and applies custom styling.
It retrieves theme and progress bar settings from the survey.qmd file.
}
\details{
The function reads the following settings from the survey.qmd YAML header:
\itemize{
\item \code{theme}: The theme to be applied to the survey.
\item \code{barcolor}: The color of the progress bar (accepts hex colors like #FF0000 or #F00, or CSS color names like red, blue, green).
\item \code{barposition}: The position of the progress bar (\code{'top'}, \code{'bottom'}, or \code{'none'}).
}

If \code{barcolor} is not specified or is \code{NULL}, the default theme color will be
used. If \code{barposition} is not specified, it defaults to 'top'.
}
\examples{
if (interactive()) {
  library(surveydown)

  # Basic sd_ui() usage in app.R:
  # library(surveydown)
  #
  # ui <- sd_ui()
  #
  # server <- function(input, output, session) {
  #   sd_server()
  # }
  #
  # shiny::shinyApp(ui = ui, server = server)

  # Find a working directory and start from a template:
  sd_create_survey(template = "default")
  # This creates survey.qmd and app.R - launch the survey using app.R
}

}
\seealso{
\code{sd_server()} for creating the server-side logic of the survey
}
