% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mspline_plots.R
\name{mspline_plotdata}
\alias{mspline_plotdata}
\title{Data for plotting an M-spline function, showing how it is built up from its basis}
\usage{
mspline_plotdata(
  knots = NULL,
  bknot = 10,
  df = 10,
  degree = 3,
  bsmooth = TRUE,
  coefs = NULL,
  scale = 1,
  tmin = 0,
  tmax = 10
)
}
\arguments{
\item{knots}{Vector of knot locations. If not supplied, \code{df}
has to be specified.  One of two rules is then used to choose the
knot locations.  If \code{bknot} is specified, a set of equally
spaced knots between zero and \code{bknot} is used.  Otherwise
if \code{obstimes} is supplied, the knots are chosen as equally
spaced quantiles of \code{obstimes}.

The number of knots (excluding zero) is \code{df - degree + 1} if
\code{bsmooth} is \code{TRUE}, or \code{df - degree - 1}
otherwise.}

\item{bknot}{Location of the final spline knot.}

\item{df}{Desired number of basis terms, or "degrees of freedom"
in the spline.  If \code{knots} is not supplied, the number of
knots is then chosen to satisfy this.}

\item{degree}{Spline polynomial degree.  Can only be changed from
the default of 3 if \code{bsmooth} is \code{FALSE}.}

\item{bsmooth}{If \code{TRUE} then the function is constrained to
also have zero derivative and second derivative at the boundary.}

\item{coefs}{Coefficients of the spline basis terms.  These are normalised internally to sum to 1,
if they do not already sum to 1.}

\item{scale}{Scale parameter. After computing the standard M-spline function as a weighted sum of the basis
terms, the function is multiplied by \code{scale}.   The log of the scale is the parameter called
\code{alpha} in the results of a \code{survextrap} model, the intercept of the linear model on the log hazard.}

\item{tmin}{Minimum plotting time.  Defaults to zero.}

\item{tmax}{Maximum plotting time.  Defaults to the highest knot.}
}
\value{
A data frame with values of the hazard at different times for different
basis functions.
}
\description{
Data for plotting an M-spline function, showing how it is built up from its basis
}
