% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom_flat_violin.R
\name{geom_flat_violin}
\alias{geom_flat_violin}
\title{geom_flat_violin for expanded density displays}
\usage{
geom_flat_violin(
  mapping = NULL,
  data = NULL,
  stat = "ydensity",
  position = "dodge",
  trim = TRUE,
  scale = "area",
  show.legend = NA,
  inherit.aes = TRUE,
  ...
)
}
\arguments{
\item{mapping}{(as usual) see \code{geom_violin()}}

\item{data}{(as usual) see \code{geom_violin()}}

\item{stat}{(as usual) see \code{geom_violin()}}

\item{position}{(as usual) see \code{geom_violin()}}

\item{trim}{If \code{TRUE} (default), trim the tails of the violins
to the range of the data. If \code{FALSE}, don't trim the tails.}

\item{scale}{if "area" (default), all violins have the same area
(before trimming the tails). If "count", areas are scaled
proportionally to the number of observations. If "width", all
violins have the same maximum width.}

\item{show.legend}{(as usual) see \code{geom_violin()}}

\item{inherit.aes}{(as usual) see \code{geom_violin()}}

\item{...}{all additional parameters are sent to the underlying \code{geom_path()}. It includes
\itemize{
\item \code{direction}  either -1,0, or +1;
\item \code{push}  a positive number.
\item \code{na.rm} (as usual) see \code{geom_violin()}
\item \code{orientation} (as usual) see \code{geom_violin()}
}}
}
\value{
a layer containing violins in a ggplot object
}
\description{
\code{geom_flat_violin()} is a geom for ggplots; it is based on
the original script to create  raincloud plots.
It relies largely on \href{https://gist.github.com/dgrtwo/eb7750e74997891d7c20}{this code}
previously written by David Robinson and the package ggplot2 by Hadley Wickham.

Code from \insertCite{allen2019;textual}{superb}

It is expanded in two different ways. First, it is possible to
decide the direction of the violin using the \code{direction} argument
(values are 0 = symmetrical; 1 = extending to the right; -1 = extending
to the left); the last two cases are "half"-violin. The second
argument is \code{push} which pushed the violin away from the median line (default = 0).
}
\examples{

library(superb) # to import the geom_flat_violin
library(ggplot2)

# let's have a fake data frame with three groups:
dta <- dta <- GRD( SubjectsPerGroup = 20,
    BSFactors = "Vacations(yes,no,maybe)",
    RenameDV = "tiredeness",
    Population = list(mean=75, stddev=15),
    Effects = list("Vacations" = custom(-20,+20,+10))
)

# The most basic plot = a regular error bar
superb( tiredeness ~ Vacations, dta)

# an example with default violins
superb( tiredeness ~ Vacations, dta, 
    plotLayout = "pointjitterviolin" )

# the same with some ornementations:  
superb( tiredeness ~ Vacations, dta, 
    plotLayout = "pointjitterviolin",
    violinParams = list(direction = 1, push = 0.2, fill="green", alpha = 0.3)
) + theme_bw() + coord_flip() + ylab("Tiredeness")

# This new geom is integrated inside superb() so that you can use it 
# directly. Let's see examples:

# show the violins only
ggplot(dta, aes(y = tiredeness, x = Vacations ) ) +
   geom_flat_violin()

# change the parameters of the violins
ggplot(dta, aes(y = tiredeness, x = Vacations ) ) +
   geom_flat_violin( fill = "green")

# all the arguments manipulated
ggplot(dta, aes(y = tiredeness, x = Vacations ) ) +
    geom_flat_violin( fill = "green", direction = 1, push =0.)

# using direction within aes
dta <- transform(dta, dir = ifelse(Vacations == "no", 1, -1))

ggplot(dta, aes(y = tiredeness, x = Vacations, direction = dir ) ) +
    geom_flat_violin( fill = "green", push =0.2)

}
\references{
\insertAllCited{}
}
