% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statpsych1.R
\name{ci.ratio.mean.ps}
\alias{ci.ratio.mean.ps}
\title{Confidence interval for a paired-samples mean ratio}
\usage{
ci.ratio.mean.ps(alpha, y1, y2)
}
\arguments{
\item{alpha}{alpha level for 1-alpha confidence}

\item{y1}{vector of measurement 1 scores}

\item{y2}{vector of measurement 2 scores (paired with y1)}
}
\value{
Returns a 1-row matrix. The columns are:
\itemize{
\item Mean1 - estimated mean for measurement 1
\item Mean2 - estimated mean for measurement 2
\item Mean1/Mean2 - estimate of mean ratio
\item LL - lower limit of the confidence interval
\item UL - upper limit of the confidence interval
}
}
\description{
Compute a confidence interval for a ratio of population means of
ratio-scale measurements in a paired-samples design. Equality of
variances is not assumed.

For more details, see Section 4.4 of Bonett (2021, Volume 1)
}
\examples{
y1 = c(76.41, 66.91, 81.06, 74.78, 83.76, 89.31, 78.78, 87.06, 82.61, 76.74, 88.33, 86.18)
y2 = c(59.85, 60.64, 84.86, 68.16, 71.53, 86.18, 67.30, 65.46, 83.50, 66.76, 88.37, 65.02)
ci.ratio.mean.ps(.05, y1, y2)

# Should return:
#    Mean1   Mean2 Mean1/Mean2       LL       UL
# 80.99417 72.3025    1.120213 1.040747 1.205745


}
\references{
\insertRef{Bonett2020b}{statpsych}

\insertRef{Bonett2021}{statpsych}
}
