% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statpsych1.R
\name{ci.mean}
\alias{ci.mean}
\title{Confidence interval for a mean}
\usage{
ci.mean(alpha, m, sd, n)
}
\arguments{
\item{alpha}{alpha level for 1-alpha confidence}

\item{m}{estimated mean}

\item{sd}{estimated standard deviation}

\item{n}{sample size}
}
\value{
Returns a 1-row matrix. The columns are:
\itemize{
\item Estimate - estimated mean
\item SE - standard error
\item LL - lower limit of the confidence interval
\item UL - upper limit of the confidence interval
}
}
\description{
Computes a confidence interval for a population mean using the estimated
mean, estimated standard deviation, and sample size. Use the t.test function
for raw data input.

For more details, see Section 1.7 of Bonett (2021, Volume 1)
}
\examples{
ci.mean(.05, 38.3, 8.14, 10)

# Should return:
# Estimate        SE       LL       UL
#     38.3  2.574094 32.47699 44.12301
 

}
\references{
\insertRef{Snedecor1980}{statpsych}

\insertRef{Bonett2021}{statpsych}
}
