% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pooled.R
\name{pooled}
\alias{pooled}
\title{Pooled polynomial detrending for multivariate panel data}
\usage{
pooled(
  df,
  id_var,
  time_var = NULL,
  vars_to_detrend,
  poly_order = 1,
  cyc_vars = NULL,
  alpha = 0.05,
  miss_thresh = 0.30
)
}
\arguments{
\item{df}{Data frame or tibble (long format).}

\item{id_var}{Character string. Unit (subject) identifier column (required).}

\item{time_var}{Character string. Numeric time index column (if NULL, then \code{cyc_vars} must be specified). If \code{NULL}, no polynomial time terms are included.}

\item{vars_to_detrend}{Character vector. Column names to detrend (required).}

\item{poly_order}{Integer in \{1,2,3\}. Maximum degree of the polynomial time trend tested (default: 1):
\itemize{
  \item 1 = linear only,
  \item 2 = linear + quadratic,
  \item 3 = linear + quadratic + cubic.
}}

\item{cyc_vars}{Character vector. Column names (e.g. "weekend") for categorical cyclicity variables (if NULL, then \code{time_var} must be specified).}

\item{alpha}{Numeric in (0,1). Significance threshold for retaining polynomial terms (default 0.05).}

\item{miss_thresh}{Numeric in (0,1). Maximum allowed proportion of missing data per variable (default: 0.30).}
}
\value{
A named list with:
\describe{
  \item{\code{df}}{Tibble with added \code{<var>_detrended} columns.}
  \item{\code{coef_tables}}{Named list of coefficient tables (one per variable), with columns \code{predictor}, \code{estimate}, \code{Std. Error}, \eqn{t}, \eqn{p}, and a logical flag \code{kept}.}
  \item{\code{formula_str}}{Character string of the fitted model formula.}
  \item{\code{n_units}}{Integer: number of unique units (subjects).}
}
}
\description{
Remove study-wide polynomial trend (up to cubic) plus optional cyclic effects
from multivariate panel data by fitting a single OLS model on the pooled 
series.   
Trend terms up to the chosen degree are estimated; those whose two-sided t-tests 
are significant at \code{alpha} are retained, non-significant components are 
set to 0, and the resulting fitted values are subtracted from every observation 
of the raw series.
}
\examples{
dat <- data.frame(
id = rep(1:3, each=5),
time = rep(1:5, 3),
cyc = rep(c("A","B"), length.out=15),
y1 = rnorm(15, sd = 0.5) + seq(1,15)*1.0
)
res <- statioVAR::pooled(
df = dat,
id_var = "id",
time_var = "time",
vars_to_detrend = "y1",
poly_order = 2,
cyc_vars = "cyc",
alpha = 0.05,
miss_thresh = 0.30
)

}
