

# Example usage of functions from the ssebEF package

# Load the package
library(ssebiEF)

albedo_path <- system.file("extdata", "albedo_reduced.tif", package = "ssebiEF")
TS_TA_path <- system.file("extdata", "TS_TA_reduced.tif", package = "ssebiEF")

cat("albedo Path: ", albedo_path, "\n")
cat("TS_TA Path: ", TS_TA_path, "\n")

print(albedo_path)

if (!file.exists(albedo_path)) {
  stop("The file albedo_reduced.tif was not found.")
}
if (!file.exists(TS_TA_path)) {
  stop("The file TS_TA_reduced.tif was not found.")
}

# Load the rasters
library(terra)
albedo <- rast(albedo_path)
TS_TA <- rast(TS_TA_path)

# Define output paths for temporary files
output_path_ssebi <- "path_to_output_SSEBI.tif"
output_path_ef <- "path_to_output_EF.tif"

# Call the function to calculate SSEBI
calculate_SSEBI(
  albedo_path = albedo,
  TS_TA_path = TS_TA,
  output_path = output_path_ssebi,
  n_intervals = 20,
  percentile = 0.01
)

# Verification of the generated SSEBI file
if (!file.exists(output_path_ssebi)) stop("SSEBI output file not created")
message("SSEBI calculation completed successfully.")

# Recharger les rasters avant le calcul de EF
albedo <- rast(albedo_path)
TS_TA <- rast(TS_TA_path)

# Call the function to calculate EF
calculate_EF(
  albedo_path = albedo,
  TS_TA_path = TS_TA,
  output_path = output_path_ef,
  n_intervals = 20,
  percentile = 0.01
)

# Verification of the generated EF file
if (!file.exists(output_path_ef)) stop("EF output file not created")
message("EF calculation completed successfully.")
