% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SRPCAMS_helpers.R
\name{scores}
\alias{scores}
\title{Calculate Scores and Distances for Multi-Source PCA}
\usage{
scores(PC, ssMRCD = NULL, X = NULL, groups = NULL, mu = NULL, Sigma = NULL)
}
\arguments{
\item{PC}{A 3D array representing the principal component loading matrices for each group
(dimensions: variables × components × groups).}

\item{ssMRCD}{An optional `ssMRCD` object used to robustly center and scale `X`. If `NULL`,
then `X`, `groups`, `mu` and `Sigma`, must be provided.}

\item{X}{An optional matrix of observations (rows are samples, columns are variables), required if `ssMRCD` is not provided.}

\item{groups}{An optional numeric vector specifying group/source membership for each observation in `X`, required if `ssMRCD` is not provided.}

\item{mu}{Optional list of group-wise means, required if `ssMRCD` is not provided.}

\item{Sigma}{Optional list of group-wise covariance matrices, required if `ssMRCD` is not provided.}
}
\value{
A list with the following components:
\describe{
  \item{scores}{Matrix of principal component scores for each observation.}
  \item{SD}{Numeric vector of score distances, i.e., Mahalanobis distances in the PCA space.}
  \item{OD}{Numeric vector of orthogonal distances (reconstruction error orthogonal to PCA space).}
  \item{X_centered}{Locally centered input data.}
}
}
\description{
Computes principal component scores, score distances (SD), and orthogonal distances (OD)
for observations grouped into multiple sources using the multi-source PCA model. The function supports
either an `ssMRCD` object for robust local centering and scaling or manually provided group-wise
means (`mu`) and covariances (`Sigma`).
}
\examples{
# create data set
x1 = matrix(runif(200), ncol = 2)
x2 = matrix(rnorm(200), ncol = 2)
x = list(x1, x2)

# create weighting matrix
W = matrix(c(0, 1, 1, 0), ncol = 2)

# calculate ssMRCD
loccovs = ssMRCD(x, weights = W, lambda = 0.5)

# calculate PCA
pca = msPCA(eta = 1, gamma = 0.5,COVS = loccovs$MRCDcov)

# calculate scores
scores_all = scores(PC = pca$PC, ssMRCD = loccovs)
str(scores_all)

scores_all = scores(PC = pca$PC,
                    X = rbind(x1, x2),
                    groups = rep(c(1,2), each = 100),
                    mu = loccovs$MRCDmu,
                    Sigma = loccovs$MRCDcov)
str(scores_all)
}
\seealso{
\code{\link[ssMRCD]{ssMRCD}}, \code{\link[ssMRCD]{scale.ssMRCD}},  \code{\link[ssMRCD]{msPCA}}
}
