% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dgp.R
\name{sim_sarar}
\alias{sim_sarar}
\title{Simulate the Spatial Autoregressive Model with Autoregressive Errors}
\usage{
sim_sarar(u, xb, listw, rho = 0.5, lambda = 0.2, model = c("sar", "ma"))
}
\arguments{
\item{u}{an error vector}

\item{xb}{predicted x values as calculated by \code{make_xb()}}

\item{listw}{a \code{listw} object generated with \code{sim_grid_listw()}.}

\item{rho}{the spatial autoregressive coefficient for the spatially lagged dependent variable.}

\item{lambda}{a value value between -1 and 1. The spatial autoregressive coefficient for the error term.}

\item{model}{default \code{"sar"}. Which model should be simulated. Provide \code{"ma"} for the moving average.}
}
\value{
A numeric vector
}
\description{
Generate \code{y} values for the "combo" / SARAR / SAC model.
}
\references{
\href{https://pysal.org/spreg/generated/spreg.dgp.dgp_lagerr.html#spreg.dgp.dgp_lagerr}{\code{spreg.dgp.dgp_lagerr}}
}
