% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dgp.R
\name{sim_durbin}
\alias{sim_durbin}
\title{Simulate the Spatial Durbin Model}
\usage{
sim_durbin(u, xb, wxg, listw, rho = 0.5)
}
\arguments{
\item{u}{an error vector}

\item{xb}{predicted x values as calculated by \code{make_xb()}}

\item{wxg}{predicted spatial lag effect as calculated by \code{make_wxg()}}

\item{listw}{a \code{listw} object generated with \code{sim_grid_listw()}.}

\item{rho}{the spatial autoregressive coefficient for the spatially lagged dependent variable.}
}
\value{
A numeric vector
}
\description{
Simulate the Spatial Durbin Model
}
\examples{
ncol <- 20
n <- ncol^2
listw <- sim_grid_listw(ncol, ncol)  # Create spatial weights for a grid
u <- make_error(n)  # Simulate random errors
x <- make_x(
  n,
  mu = c(0.25, 5),
  var = c(1, 0.75),
  method = "normal"
)  # Generate x variables

# create xb with intercept = 1, beta1 = 2, beta2 = -3
xb <- make_xb(x, c(1, 2, -3))
wx <- make_wx(x, listw)
wxg <- make_wxg(wx, c(-2, 1.5))
y <- sim_durbin(u, xb, wxg, listw, rho = 0.5)

# combine data 
df <- cbind(y = y, x)

# fit SDM
spatialreg::lagsarlm(y ~ ., df, listw, Durbin = TRUE)
}
\references{
\href{https://pysal.org/spreg/generated/spreg.dgp.dgp_spdurbin.html#spreg.dgp.dgp_spdurbin}{\code{spreg.dgp.dgp_spdurbin}}
}
