% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pulse_sequences.R
\name{seq_steam_ideal_young}
\alias{seq_steam_ideal_young}
\title{STEAM sequence with ideal pulses using the z-rotation gradient simulation
method described by Young et al JMR 140, 146-152 (1999).}
\usage{
seq_steam_ideal_young(
  spin_params,
  ft,
  ref,
  TE = 0.03,
  TM = 0.02,
  amp_scale = 2
)
}
\arguments{
\item{spin_params}{spin system definition.}

\item{ft}{transmitter frequency in Hz.}

\item{ref}{reference value for ppm scale.}

\item{TE}{sequence parameter in seconds.}

\item{TM}{sequence parameter in seconds.}

\item{amp_scale}{amplitude scaling factor. Set to 2 (default) to ensure
correct scaling for water reference scaling. Set to 1 to maintain the
inherent loss of signal associated with STEAM.}
}
\value{
list of resonance amplitudes and frequencies.
}
\description{
STEAM sequence with ideal pulses using the z-rotation gradient simulation
method described by Young et al JMR 140, 146-152 (1999).
}
