% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_build_plot.r
\name{add.quadrant.labels}
\alias{add.quadrant.labels}
\title{Annotate labels to the quadrants of an MCA or any ggplot2 based quadrant plot.}
\usage{
add.quadrant.labels(
  quadrant.labels = c("A", "B", "C", "D"),
  distance = "npc",
  geom = "label",
  color = "black",
  ...
)
}
\arguments{
\item{quadrant.labels}{a character string with the labels for each quadrant}

\item{distance}{if equal to "npc" labels are positioned dynamically at the edges of the plot. see \link[ggpp]{annotate}. If a numeric vector it is interpreted as the distance to 0 on both X and Y.}

\item{geom}{controls the annotation geom; usually you would use "text" or "label".}

\item{color}{either a single value or 4 values that control the color of the labels}

\item{...}{further arguments are passed onto \link[ggpp]{annotate}}
}
\value{
a ggplot2 layer that can be added to an existing ggplot object.
}
\description{
This function is a convience function that uses \link[ggpp]{annotate} to easily create labels for the quadrants.
}
\examples{
example(soc.mca)
map.ind(result, point.size = 1) + add.quadrant.labels()
labels <- c("Dominant:\nCultural fraction", "Dominant:\nEconomic fraction",
            "Dominated:\nEconomic fraction", "Dominated:\nCultural fraction")
map.ca.base() + add.quadrant.labels(labels, geom = "text")
map.ca.base() + add.ind(result, color = "grey80") + 
                add.quadrant.labels(labels, geom = "text", distance = 1) 
map.ca.base() + add.categories(result, color = "grey50", check_overlap = TRUE) +
               add.quadrant.labels(labels, geom = "label", distance = 0.5,
               fill = c("#E41A1C", "#377EB8", "#4DAF4A", "#984EA3"), alpha = 0.3) 
}
