% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.boin_multi_summary.R
\name{print.boin_multi_summary}
\alias{print.boin_multi_summary}
\title{Print Method for BOIN Multi-Scenario Summary}
\usage{
\method{print}{boin_multi_summary}(x, scenario_name = NULL, percent = FALSE, kable = FALSE, kable_format = "pipe", ...)
}
\arguments{
\item{x}{Object of class "boin_multi_summary" returned by \code{sim_boin_multi()}.}

\item{scenario_name}{Character. Optional name for display header (for compatibility with print.boin_summary).
Ignored for multi-scenario results. Default is NULL.}

\item{percent}{Logical. If TRUE, display "Avg Pts" and "Avg DLTs" as percentages of totals.
If FALSE (default), display as absolute numbers. Default is FALSE.}

\item{kable}{Logical. If TRUE, format output as knitr::kable table. If FALSE (default),
display as plain text table. Default is FALSE.}

\item{kable_format}{Character. Format for kable output when kable = TRUE. Options include
"pipe" (Markdown pipes, default), "simple" (minimal formatting),
"latex" (LaTeX format), and "html" (HTML format). Default is "pipe".}

\item{...}{Additional arguments (currently unused, for S3 method consistency).}
}
\value{
Invisibly returns the input object \code{x}. Function is called for printing side effect.
}
\description{
Custom print method for "boin_multi_summary" objects returned by
\code{sim_boin_multi()}. Displays aggregated operating characteristics
in formatted tables with options for plain text or kable output.
}
\details{
Displays a summary table with:
\itemize{
\item Rows organized by scenario and metric (True Tox (\%), MTD Sel (\%), Avg Pts, Avg DLTs)
\item Columns for each dose level plus Total/No MTD statistics
\item Scenario names grouped for easy visual comparison
\item All text left-aligned for consistency
}

When \code{percent = FALSE} (default), "Avg Pts" and "Avg DLTs" are displayed
as absolute numbers.

When \code{percent = TRUE}, these rows display percentages of their respective
totals for each trial. This facilitates visual comparison of dose allocation
patterns across scenarios independent of total sample size.

When \code{kable = FALSE} (default), displays as plain text table in console.

When \code{kable = TRUE}, formats the table using \code{knitr::kable()} with
the specified format. This is useful for R Markdown documents and reports.
The \code{kable_format} parameter controls output format:
\itemize{
\item \code{"pipe"}: Markdown pipe format (best for GitHub/Markdown)
\item \code{"simple"}: Minimal formatting (plain text)
\item \code{"latex"}: LaTeX format (for PDF reports)
\item \code{"html"}: HTML format (for web display)
}

All columns are left-aligned for improved readability across all formats.
}
\examples{
\dontrun{
# Create multi-scenario simulation results
scenarios <- list(
  list(name = "Scenario 1",
       p_true = c(0.05, 0.10, 0.15, 0.20, 0.25, 0.30, 0.35, 0.40, 0.45)),
  list(name = "Scenario 2",
       p_true = c(0.01, 0.025, 0.05, 0.075, 0.10, 0.125, 0.15, 0.20, 0.30))
)

result <- sim_boin_multi(
  scenarios = scenarios,
  target = 0.30,
  n_trials = 1000,
  n_cohort = 48,
  cohort_size = 3,
  seed = 123
)

# Print as plain text with absolute numbers (default)
print(result)

# Print with absolute numbers as Markdown table
print(result, kable = TRUE, kable_format = "pipe")

# Print with percentages instead of absolute numbers
print(result, percent = TRUE)

# Print with percentages as Markdown table
print(result, kable = TRUE, kable_format = "pipe", percent = TRUE)

# Print as LaTeX table for PDF documents
print(result, kable = TRUE, kable_format = "latex")

# Print as HTML table
print(result, kable = TRUE, kable_format = "html")
}

}
\references{
Liu S. and Yuan, Y. (2015). Bayesian Optimal Interval Designs for Phase I Clinical
Trials. Journal of the Royal Statistical Society: Series C, 64, 507-523.
}
