% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_boin_stopping_boundaries.R
\name{get_boin_stopping_boundaries}
\alias{get_boin_stopping_boundaries}
\title{Generate Trial Stopping Rule Table}
\usage{
get_boin_stopping_boundaries(target, max_sample_size, cutoff_stop)
}
\arguments{
\item{target}{Numeric. The target toxicity probability (e.g., 0.30 for 30\%).}

\item{max_sample_size}{Numeric. Maximum sample size (number of patients) for table columns.
Typically 18-30 for phase I trials.}

\item{cutoff_stop}{Numeric. Cutoff probability for trial stopping. Default is 0.90.
If Pr(p > target | data) > cutoff_stop at lowest dose, the trial is stopped.}
}
\value{
A character matrix with stopping decisions:
\itemize{
\item Rows represent cumulative number of DLTs at lowest dose (0 to max_sample_size)
\item Columns represent cumulative number of patients at lowest dose (1 to max_sample_size)
\item Cell values are "STOP" or "GO"
\item NA values for logically impossible combinations (n_tox > n_pts) or n_pts < 3
}
}
\description{
Create a lookup table to determine whether the entire trial should be stopped
if excessive toxicity is observed at the lowest dose. This table is applied
only at the lowest dose level to monitor trial safety.
}
\details{
The trial stopping rule is based on Bayesian monitoring of safety at the lowest
dose level. The rationale is that if even the lowest dose shows excessive toxicity
with high posterior probability, all doses in the trial may be too toxic, warranting
early trial termination.

The posterior probability Pr(p > target | data) is computed using Beta-Binomial
conjugate prior with uniform prior (Beta(1,1)). The stopping rule is not evaluated
until at least 3 patients have been treated at the lowest dose.
}
\examples{
# Generate stopping rule table for 30\% target toxicity rate
STOP_DL1 <- get_boin_stopping_boundaries(
  target = 0.30,
  max_sample_size = 18,
  cutoff_stop = 0.90
)
print(STOP_DL1)

}
\references{
Liu S. and Yuan, Y. (2015). Bayesian Optimal Interval Designs for Phase I Clinical
Trials. Journal of the Royal Statistical Society: Series C, 64, 507-523.
}
