% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bpemb.R
\name{BPEembedder}
\alias{BPEembedder}
\title{Build a BPEembed model containing a Sentencepiece and Word2vec model}
\usage{
BPEembedder(
  x,
  tokenizer = c("bpe", "char", "unigram", "word"),
  args = list(vocab_size = 8000, coverage = 0.9999),
  ...
)
}
\arguments{
\item{x}{a data.frame with columns doc_id and text}

\item{tokenizer}{character string with the type of sentencepiece tokenizer. Either 'bpe', 'char', 'unigram' or 'word' for Byte Pair Encoding, Character level encoding,
Unigram encoding or pretokenised word encoding. Defaults to 'bpe' (Byte Pair Encoding). Passed on to \code{\link{sentencepiece}}}

\item{args}{a list of arguments passed on to \code{\link{sentencepiece}}}

\item{...}{arguments passed on to \code{\link[word2vec]{word2vec}} for training a word2vec model}
}
\value{
an object of class BPEembed which is a list with elements 
\itemize{
\item{model: a sentencepiece model as loaded with \code{\link{sentencepiece_load_model}}}
\item{embedding: a matrix with embeddings as loaded with \code{\link[word2vec]{read.wordvectors}}}
\item{dim: the dimension of the embedding}
\item{n: the number of elements in the vocabulary}
\item{file_sentencepiece: the sentencepiece model file}
\item{file_word2vec: the word2vec embedding file}
}
}
\description{
Build a sentencepiece model on text and build a matching word2vec model on the sentencepiece vocabulary
}
\examples{
library(tokenizers.bpe)
data(belgium_parliament, package = "tokenizers.bpe")
x     <- subset(belgium_parliament, language \%in\% "dutch")
model <- BPEembedder(x, tokenizer = "bpe", args = list(vocab_size = 1000),
                     type = "cbow", dim = 20, iter = 10) 
model

txt    <- c("De eigendomsoverdracht aan de deelstaten is ingewikkeld.")
values <- predict(model, txt, type = "encode")  
}
\seealso{
\code{\link{sentencepiece}}, \code{\link[word2vec]{word2vec}}, \code{\link{predict.BPEembed}}
}
