% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/st_session_metrics.R
\name{st_session_metrics}
\alias{st_session_metrics}
\title{Fetch Session Metrics Time Series Data}
\usage{
st_session_metrics(
  unified_app_id = NULL,
  ios_app_id = NULL,
  android_app_id = NULL,
  start_date,
  end_date,
  metrics = c("session_count", "session_duration", "time_spent"),
  regions = "US",
  time_period = "week",
  date_granularity = "monthly",
  os = NULL,
  breakdown = "unified_app_id",
  auth_token = NULL,
  verbose = TRUE
)
}
\arguments{
\item{unified_app_id}{Character string or vector. Sensor Tower unified app ID(s)
(24-character hex). Maximum 100 apps per request.}

\item{ios_app_id}{Character string or vector. iOS app ID(s) for non-unified queries.}

\item{android_app_id}{Character string or vector. Android package name(s) for
non-unified queries.}

\item{start_date}{Date or character string. Start date in "YYYY-MM-DD" format.
Data is available from 2021-01-01 onward.}

\item{end_date}{Date or character string. End date in "YYYY-MM-DD" format.}

\item{metrics}{Character vector. Metrics to retrieve. Options include:
- "time_spent" (average seconds per user per day)
- "total_time_spent" (total seconds across all users)
- "session_duration" (average session length in seconds)
- "session_count" (average sessions per user per day)
- "total_session_count" (total sessions across all users)
Default is c("session_count", "session_duration", "time_spent").}

\item{regions}{Character vector. Region/country codes (e.g., "US", "GB").
Default is "US". Use NULL for all regions.}

\item{time_period}{Character string. Session metrics time period.
Options: "day", "week". Default is "week".
Returns averaged session metrics for each period within a month.}

\item{date_granularity}{Character string. Aggregate data by granularity.
Options: "daily", "weekly", "monthly". Default is "monthly".
Note: "daily" granularity may not be supported by the API for all apps;
use "weekly" or "monthly" if you receive empty results with "daily".}

\item{os}{Character string. Filter by platform for unified apps.
Options: "ios", "android", or NULL for both. Default is NULL.}

\item{breakdown}{Character string. Fields for data aggregation.
Options: "unified_app_id", "app_id", "region". Default is "unified_app_id".}

\item{auth_token}{Character string. Your Sensor Tower API token.
Defaults to environment variable SENSORTOWER_AUTH_TOKEN.}

\item{verbose}{Logical. If TRUE, prints progress messages.}
}
\value{
A [tibble][tibble::tibble] with session metrics including:
  - **unified_app_id** or **app_id**: The app identifier
  - **date**: Date of the data point
  - **time_spent**: Average seconds spent per user per day
  - **total_time_spent**: Total seconds across all users
  - **session_duration**: Average session length in seconds
  - **session_count**: Average sessions per user per day
  - **total_session_count**: Total session count across all users
}
\description{
Retrieves session metrics time series data (session count, session duration,
time spent) for apps from the Sensor Tower Usage Intelligence API.
}
\section{Data Availability}{

- Data is available from 2021-01-01 onward
- Session metrics require Usage Intelligence subscription
- Maximum 100 apps per request
}

\examples{
\dontrun{
# Get session metrics for a unified app
sessions <- st_session_metrics(
  unified_app_id = "5fbc3849d0b8414136857afc",
  start_date = "2024-01-01",
  end_date = "2024-12-01"
)

# Get specific metrics with weekly granularity
sessions <- st_session_metrics(
  unified_app_id = "5fbc3849d0b8414136857afc",
  start_date = "2024-01-01",
  end_date = "2024-03-01",
  metrics = c("session_count", "session_duration"),
  date_granularity = "weekly"
)

# Get session data for Android app directly
sessions <- st_session_metrics(
  android_app_id = "com.example.app",
  start_date = "2024-01-01",
  end_date = "2024-06-01"
)
}

}
\seealso{
[st_retention()] for retention metrics,
  [st_demographics()] for user demographics,
  [st_batch_metrics()] for MAU/DAU/WAU metrics
}
