% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/st_get_unified_mapping.R
\name{st_get_unified_mapping}
\alias{st_get_unified_mapping}
\title{Get Unified ID Mapping for Apps}
\usage{
st_get_unified_mapping(
  app_ids,
  app_names = NULL,
  os = "unified",
  auth_token = Sys.getenv("SENSORTOWER_AUTH_TOKEN")
)
}
\arguments{
\item{app_ids}{Character vector of app IDs (can be iOS, Android, or unified hex IDs)}

\item{app_names}{Character vector of app names (optional, helps with resolution)}

\item{os}{Character string. Operating system: "ios", "android", or "unified"}

\item{auth_token}{Character string. Sensor Tower API authentication token.
Defaults to environment variable SENSORTOWER_AUTH_TOKEN.}
}
\value{
A data frame with columns:
  - `input_id`: The original ID provided
  - `unified_app_id`: The unified app ID (hex format)
  - `unified_app_name`: The unified app name
  - `ios_app_id`: iOS app ID (if available)
  - `android_app_id`: Android app ID (if available)
  - `publisher_id`: Publisher ID
  - `publisher_name`: Publisher name
}
\description{
Retrieves the mapping between platform-specific app IDs and unified app IDs.
This function handles cases where platform IDs from st_top_charts may not be
directly searchable, using app names as a fallback resolution method.
}
\details{
This function uses an ID-first approach (no name-based resolution):
1. For hex IDs (24-char), uses st_app_lookup to get platform IDs
2. For platform IDs, first tries to look them up via st_app_lookup
3. If direct lookup fails, searches the unified index using the platform ID
   as the term and matches exact IDs within nested ios_apps/android_apps
4. Returns the best available mapping for each app using IDs only

Note: Platform IDs from st_top_charts may be regional or legacy IDs that
aren't directly searchable. In these cases, name-based search provides
the most reliable resolution to unified IDs.
}
\examples{
\dontrun{
# Get mapping with app names for better resolution
mapping <- st_get_unified_mapping(
  app_ids = c("943599237", "com.bandainamcogames.dbzdokkan"),
  app_names = c("Dragon Ball Z Dokkan Battle", "Dragon Ball Z Dokkan Battle"),
  os = "unified"
)
}

}
