
# Expected output ---------------------------------------------------------

# These expected outputs were created using `constructive::construct()`:

pigs1_exp <- tibble::tibble(
  x = c(
    "4.69", "4.70", "4.71", "4.72", "4.73", "4.75", "4.76", "4.77", "4.78",
    "4.79", "5.18", "5.19", "5.20", "5.21", "5.22", "5.24", "5.25", "5.26",
    "5.27", "5.28", "2.52", "2.53", "2.54", "2.55", "2.56", "2.58", "2.59",
    "2.60", "2.61", "2.62", "6.72", "6.73", "6.74", "6.75", "6.76", "6.78",
    "6.79", "6.80", "6.81", "6.82", "6.96", "6.97", "6.98", "6.99", "7.00",
    "7.02", "7.03", "7.04", "7.05", "7.06", "3.09", "3.10", "3.11", "3.12",
    "3.13", "3.15", "3.16", "3.17", "3.18", "3.19", "6.84", "6.85", "6.86",
    "6.87", "6.88", "6.90", "6.91", "6.92", "6.93", "6.94", "0.19", "0.20",
    "0.21", "0.22", "0.23", "0.25", "0.26", "0.27", "0.28", "0.29", "4.74",
    "4.74", "4.74", "4.74", "4.74", "4.74", "4.74", "4.74", "4.74", "4.74",
    "5.23", "5.23", "5.23", "5.23", "5.23", "5.23", "5.23", "5.23", "5.23",
    "5.23", "2.57", "2.57", "2.57", "2.57", "2.57", "2.57", "2.57", "2.57",
    "2.57", "2.57", "6.77", "6.77", "6.77", "6.77", "6.77", "6.77", "6.77",
    "6.77", "6.77", "6.77", "7.01", "7.01", "7.01", "7.01", "7.01", "7.01",
    "7.01", "7.01", "7.01", "7.01", "3.14", "3.14", "3.14", "3.14", "3.14",
    "3.14", "3.14", "3.14", "3.14", "3.14", "6.89", "6.89", "6.89", "6.89",
    "6.89", "6.89", "6.89", "6.89", "6.89", "6.89", "0.24", "0.24", "0.24",
    "0.24", "0.24", "0.24", "0.24", "0.24", "0.24", "0.24"
  ),
  n = c(
    25L, 25L, 25L, 25L, 25L, 25L, 25L, 25L, 25L, 25L, 29L, 29L, 29L, 29L, 29L,
    29L, 29L, 29L, 29L, 29L, 24L, 24L, 24L, 24L, 24L, 24L, 24L, 24L, 24L, 24L,
    27L, 27L, 27L, 27L, 27L, 27L, 27L, 27L, 27L, 27L, 29L, 29L, 29L, 29L, 29L,
    29L, 29L, 29L, 29L, 29L, 27L, 27L, 27L, 27L, 27L, 27L, 27L, 27L, 27L, 27L,
    31L, 31L, 31L, 31L, 31L, 31L, 31L, 31L, 31L, 31L, 28L, 28L, 28L, 28L, 28L,
    28L, 28L, 28L, 28L, 28L, 20L, 21L, 22L, 23L, 24L, 26L, 27L, 28L, 29L, 30L,
    24L, 25L, 26L, 27L, 28L, 30L, 31L, 32L, 33L, 34L, 19L, 20L, 21L, 22L, 23L,
    25L, 26L, 27L, 28L, 29L, 22L, 23L, 24L, 25L, 26L, 28L, 29L, 30L, 31L, 32L,
    24L, 25L, 26L, 27L, 28L, 30L, 31L, 32L, 33L, 34L, 22L, 23L, 24L, 25L, 26L,
    28L, 29L, 30L, 31L, 32L, 26L, 27L, 28L, 29L, 30L, 32L, 33L, 34L, 35L, 36L,
    23L, 24L, 25L, 26L, 27L, 29L, 30L, 31L, 32L, 33L
  ),
  consistency = c(
    FALSE, FALSE, FALSE, TRUE, FALSE, FALSE, TRUE, FALSE, FALSE, FALSE, FALSE,
    FALSE, FALSE, TRUE, FALSE, TRUE, FALSE, FALSE, FALSE, TRUE, FALSE, FALSE,
    TRUE, FALSE, FALSE, TRUE, FALSE, FALSE, FALSE, TRUE, FALSE, FALSE, TRUE,
    FALSE, FALSE, TRUE, FALSE, FALSE, TRUE, FALSE, FALSE, TRUE, FALSE, FALSE,
    TRUE, FALSE, TRUE, FALSE, FALSE, FALSE, FALSE, FALSE, TRUE, FALSE, FALSE,
    TRUE, FALSE, FALSE, FALSE, TRUE, TRUE, FALSE, FALSE, TRUE, FALSE, TRUE, FALSE,
    FALSE, FALSE, TRUE, FALSE, FALSE, TRUE, FALSE, FALSE, TRUE, FALSE, FALSE,
    FALSE, TRUE, FALSE, FALSE, FALSE, TRUE, FALSE, FALSE, TRUE, FALSE, FALSE,
    FALSE, FALSE, FALSE, TRUE, FALSE, FALSE, TRUE, TRUE, FALSE, FALSE, FALSE,
    FALSE, FALSE, TRUE, FALSE, TRUE, FALSE, FALSE, FALSE, TRUE, FALSE, TRUE,
    FALSE, FALSE, FALSE, TRUE, FALSE, FALSE, TRUE, TRUE, FALSE, FALSE, FALSE,
    FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, TRUE, FALSE, FALSE,
    FALSE, FALSE, TRUE, TRUE, FALSE, FALSE, FALSE, FALSE, TRUE, TRUE, FALSE,
    FALSE, FALSE, FALSE, FALSE, TRUE, TRUE, FALSE, FALSE, TRUE, FALSE, FALSE,
    TRUE, FALSE, FALSE, FALSE, TRUE
  ),
  probability = c(
    0.75, 0.75, 0.75, 0.75, 0.75, 0.75, 0.75, 0.75, 0.75, 0.75, 0.71, 0.71, 0.71,
    0.71, 0.71, 0.71, 0.71, 0.71, 0.71, 0.71, 0.76, 0.76, 0.76, 0.76, 0.76, 0.76,
    0.76, 0.76, 0.76, 0.76, 0.73, 0.73, 0.73, 0.73, 0.73, 0.73, 0.73, 0.73, 0.73,
    0.73, 0.71, 0.71, 0.71, 0.71, 0.71, 0.71, 0.71, 0.71, 0.71, 0.71, 0.73, 0.73,
    0.73, 0.73, 0.73, 0.73, 0.73, 0.73, 0.73, 0.73, 0.69, 0.69, 0.69, 0.69, 0.69,
    0.69, 0.69, 0.69, 0.69, 0.69, 0.72, 0.72, 0.72, 0.72, 0.72, 0.72, 0.72, 0.72,
    0.72, 0.72, 0.8, 0.79, 0.78, 0.77, 0.76, 0.74, 0.73, 0.72, 0.71, 0.7, 0.76,
    0.75, 0.74, 0.73, 0.72, 0.7, 0.69, 0.68, 0.67, 0.66, 0.81, 0.8, 0.79, 0.78,
    0.77, 0.75, 0.74, 0.73, 0.72, 0.71, 0.78, 0.77, 0.76, 0.75, 0.74, 0.72, 0.71,
    0.7, 0.69, 0.68, 0.76, 0.75, 0.74, 0.73, 0.72, 0.7, 0.69, 0.68, 0.67, 0.66,
    0.78, 0.77, 0.76, 0.75, 0.74, 0.72, 0.71, 0.7, 0.69, 0.68, 0.74, 0.73, 0.72,
    0.71, 0.7, 0.68, 0.67, 0.66, 0.65, 0.64, 0.77, 0.76, 0.75, 0.74, 0.73, 0.71,
    0.7, 0.69, 0.68, 0.67
  ),
  diff_var = rep(c(-5L, -4L, -3L, -2L, -1L, 1L, 2L, 3L, 4L, 5L), 16),
  case = rep(rep(1:8, 2), each = 10L),
  var = rep(c("x", "n"), each = 80L),
) %>%
  structure(
    class = c(
      "scr_map_seq", "scr_grim_map_seq", "scr_grim_map", "scr_rounding_up_or_down",
      "tbl_df", "tbl", "data.frame"
    )
  )


pigs2_exp <- tibble::tibble(
  x = c(
    "0.669", "0.670", "0.671", "0.672", "0.673", "0.675", "0.676", "0.677",
    "0.678", "0.679", "0.537", "0.538", "0.539", "0.540", "0.541", "0.543",
    "0.544", "0.545", "0.546", "0.547", "0.693", "0.694", "0.695", "0.696",
    "0.697", "0.699", "0.700", "0.701", "0.702", "0.703", "0.676", "0.677",
    "0.678", "0.679", "0.680", "0.682", "0.683", "0.684", "0.685", "0.686",
    "0.549", "0.550", "0.551", "0.552", "0.553", "0.555", "0.556", "0.557",
    "0.558", "0.559", "0.674", "0.674", "0.674", "0.674", "0.674", "0.674",
    "0.674", "0.674", "0.674", "0.674", "0.542", "0.542", "0.542", "0.542",
    "0.542", "0.542", "0.542", "0.542", "0.542", "0.542", "0.698", "0.698",
    "0.698", "0.698", "0.698", "0.698", "0.698", "0.698", "0.698", "0.698",
    "0.681", "0.681", "0.681", "0.681", "0.681", "0.681", "0.681", "0.681",
    "0.681", "0.681", "0.554", "0.554", "0.554", "0.554", "0.554", "0.554",
    "0.554", "0.554", "0.554", "0.554"
  ),
  n = c(
    150L, 150L, 150L, 150L, 150L, 150L, 150L, 150L, 150L, 150L, 150L, 150L, 150L,
    150L, 150L, 150L, 150L, 150L, 150L, 150L, 150L, 150L, 150L, 150L, 150L, 150L,
    150L, 150L, 150L, 150L, 150L, 150L, 150L, 150L, 150L, 150L, 150L, 150L, 150L,
    150L, 150L, 150L, 150L, 150L, 150L, 150L, 150L, 150L, 150L, 150L, 145L, 146L,
    147L, 148L, 149L, 151L, 152L, 153L, 154L, 155L, 145L, 146L, 147L, 148L, 149L,
    151L, 152L, 153L, 154L, 155L, 145L, 146L, 147L, 148L, 149L, 151L, 152L, 153L,
    154L, 155L, 145L, 146L, 147L, 148L, 149L, 151L, 152L, 153L, 154L, 155L, 145L,
    146L, 147L, 148L, 149L, 151L, 152L, 153L, 154L, 155L
  ),
  consistency = rep(
    c(
      FALSE, TRUE, FALSE, TRUE, FALSE, TRUE, FALSE, TRUE, FALSE, TRUE, FALSE, TRUE,
      FALSE, TRUE, FALSE, TRUE, FALSE, TRUE, FALSE, TRUE, FALSE
    ),
    c(4L, 1L, 8L, 1L, 5L, 2L, 5L, 1L, 7L, 1L, 9L, 1L, 22L, 1L, 1L, 1L, 4L, 1L, 18L, 1L, 6L)
  ),
  probability = c(
    0.85, 0.85, 0.85, 0.85, 0.85, 0.85, 0.85, 0.85, 0.85, 0.85, 0.85, 0.85, 0.85,
    0.85, 0.85, 0.85, 0.85, 0.85, 0.85, 0.85, 0.85, 0.85, 0.85, 0.85, 0.85, 0.85,
    0.85, 0.85, 0.85, 0.85, 0.85, 0.85, 0.85, 0.85, 0.85, 0.85, 0.85, 0.85, 0.85,
    0.85, 0.85, 0.85, 0.85, 0.85, 0.85, 0.85, 0.85, 0.85, 0.85, 0.85, 0.855,
    0.854, 0.853, 0.852, 0.851, 0.849, 0.848, 0.847, 0.846, 0.845, 0.855, 0.854,
    0.853, 0.852, 0.851, 0.849, 0.848, 0.847, 0.846, 0.845, 0.855, 0.854, 0.853,
    0.852, 0.851, 0.849, 0.848, 0.847, 0.846, 0.845, 0.855, 0.854, 0.853, 0.852,
    0.851, 0.849, 0.848, 0.847, 0.846, 0.845, 0.855, 0.854, 0.853, 0.852, 0.851,
    0.849, 0.848, 0.847, 0.846, 0.845
  ),
  diff_var = rep(c(-5L, -4L, -3L, -2L, -1L, 1L, 2L, 3L, 4L, 5L), 10),
  case = rep(rep(1:5, 2), each = 10L),
  var = rep(c("x", "n"), each = 50L),
) %>%
  structure(
    class = c(
      "scr_map_seq", "scr_grim_map_seq", "scr_grim_map", "scr_rounding_up_or_down",
      "tbl_df", "tbl", "data.frame"
    )
  )


pigs1_include_reported_exp <- tibble::tibble(
  x = c(
    "4.69", "4.70", "4.71", "4.72", "4.73", "4.74", "4.75", "4.76", "4.77",
    "4.78", "4.79", "5.18", "5.19", "5.20", "5.21", "5.22", "5.23", "5.24",
    "5.25", "5.26", "5.27", "5.28", "2.52", "2.53", "2.54", "2.55", "2.56",
    "2.57", "2.58", "2.59", "2.60", "2.61", "2.62", "6.72", "6.73", "6.74",
    "6.75", "6.76", "6.77", "6.78", "6.79", "6.80", "6.81", "6.82", "6.96",
    "6.97", "6.98", "6.99", "7.00", "7.01", "7.02", "7.03", "7.04", "7.05",
    "7.06", "3.09", "3.10", "3.11", "3.12", "3.13", "3.14", "3.15", "3.16",
    "3.17", "3.18", "3.19", "6.84", "6.85", "6.86", "6.87", "6.88", "6.89",
    "6.90", "6.91", "6.92", "6.93", "6.94", "0.19", "0.20", "0.21", "0.22",
    "0.23", "0.24", "0.25", "0.26", "0.27", "0.28", "0.29", "4.74", "4.74",
    "4.74", "4.74", "4.74", "4.74", "4.74", "4.74", "4.74", "4.74", "4.74",
    "5.23", "5.23", "5.23", "5.23", "5.23", "5.23", "5.23", "5.23", "5.23",
    "5.23", "5.23", "2.57", "2.57", "2.57", "2.57", "2.57", "2.57", "2.57",
    "2.57", "2.57", "2.57", "2.57", "6.77", "6.77", "6.77", "6.77", "6.77",
    "6.77", "6.77", "6.77", "6.77", "6.77", "6.77", "7.01", "7.01", "7.01",
    "7.01", "7.01", "7.01", "7.01", "7.01", "7.01", "7.01", "7.01", "3.14",
    "3.14", "3.14", "3.14", "3.14", "3.14", "3.14", "3.14", "3.14", "3.14",
    "3.14", "6.89", "6.89", "6.89", "6.89", "6.89", "6.89", "6.89", "6.89",
    "6.89", "6.89", "6.89", "0.24", "0.24", "0.24", "0.24", "0.24", "0.24",
    "0.24", "0.24", "0.24", "0.24", "0.24"
  ),
  n = c(
    25L, 25L, 25L, 25L, 25L, 25L, 25L, 25L, 25L, 25L, 25L, 29L, 29L, 29L, 29L,
    29L, 29L, 29L, 29L, 29L, 29L, 29L, 24L, 24L, 24L, 24L, 24L, 24L, 24L, 24L,
    24L, 24L, 24L, 27L, 27L, 27L, 27L, 27L, 27L, 27L, 27L, 27L, 27L, 27L, 29L,
    29L, 29L, 29L, 29L, 29L, 29L, 29L, 29L, 29L, 29L, 27L, 27L, 27L, 27L, 27L,
    27L, 27L, 27L, 27L, 27L, 27L, 31L, 31L, 31L, 31L, 31L, 31L, 31L, 31L, 31L,
    31L, 31L, 28L, 28L, 28L, 28L, 28L, 28L, 28L, 28L, 28L, 28L, 28L, 20L, 21L,
    22L, 23L, 24L, 25L, 26L, 27L, 28L, 29L, 30L, 24L, 25L, 26L, 27L, 28L, 29L,
    30L, 31L, 32L, 33L, 34L, 19L, 20L, 21L, 22L, 23L, 24L, 25L, 26L, 27L, 28L,
    29L, 22L, 23L, 24L, 25L, 26L, 27L, 28L, 29L, 30L, 31L, 32L, 24L, 25L, 26L,
    27L, 28L, 29L, 30L, 31L, 32L, 33L, 34L, 22L, 23L, 24L, 25L, 26L, 27L, 28L,
    29L, 30L, 31L, 32L, 26L, 27L, 28L, 29L, 30L, 31L, 32L, 33L, 34L, 35L, 36L,
    23L, 24L, 25L, 26L, 27L, 28L, 29L, 30L, 31L, 32L, 33L
  ),
  consistency = rep(
    rep(c(FALSE, TRUE), 40),
    c(
      3L, 1L, 3L, 1L, 6L, 1L, 2L, 1L, 3L, 1L, 2L, 1L, 3L, 1L, 3L, 1L, 2L, 1L, 3L,
      1L, 2L, 1L, 2L, 1L, 2L, 1L, 2L, 1L, 5L, 1L, 3L, 1L, 3L, 2L, 2L, 1L, 2L, 1L,
      3L, 1L, 2L, 1L, 3L, 1L, 3L, 1L, 3L, 1L, 3L, 1L, 5L, 1L, 3L, 2L, 5L, 1L, 1L,
      1L, 4L, 1L, 1L, 1L, 3L, 1L, 3L, 2L, 12L, 1L, 5L, 2L, 4L, 2L, 6L, 2L, 2L, 1L,
      3L, 1L, 3L, 1L
    )
  ),
  probability = c(
    0.75, 0.75, 0.75, 0.75, 0.75, 0.75, 0.75, 0.75, 0.75, 0.75, 0.75, 0.71, 0.71,
    0.71, 0.71, 0.71, 0.71, 0.71, 0.71, 0.71, 0.71, 0.71, 0.76, 0.76, 0.76, 0.76,
    0.76, 0.76, 0.76, 0.76, 0.76, 0.76, 0.76, 0.73, 0.73, 0.73, 0.73, 0.73, 0.73,
    0.73, 0.73, 0.73, 0.73, 0.73, 0.71, 0.71, 0.71, 0.71, 0.71, 0.71, 0.71, 0.71,
    0.71, 0.71, 0.71, 0.73, 0.73, 0.73, 0.73, 0.73, 0.73, 0.73, 0.73, 0.73, 0.73,
    0.73, 0.69, 0.69, 0.69, 0.69, 0.69, 0.69, 0.69, 0.69, 0.69, 0.69, 0.69, 0.72,
    0.72, 0.72, 0.72, 0.72, 0.72, 0.72, 0.72, 0.72, 0.72, 0.72, 0.8, 0.79, 0.78,
    0.77, 0.76, 0.75, 0.74, 0.73, 0.72, 0.71, 0.7, 0.76, 0.75, 0.74, 0.73, 0.72,
    0.71, 0.7, 0.69, 0.68, 0.67, 0.66, 0.81, 0.8, 0.79, 0.78, 0.77, 0.76, 0.75,
    0.74, 0.73, 0.72, 0.71, 0.78, 0.77, 0.76, 0.75, 0.74, 0.73, 0.72, 0.71, 0.7,
    0.69, 0.68, 0.76, 0.75, 0.74, 0.73, 0.72, 0.71, 0.7, 0.69, 0.68, 0.67, 0.66,
    0.78, 0.77, 0.76, 0.75, 0.74, 0.73, 0.72, 0.71, 0.7, 0.69, 0.68, 0.74, 0.73,
    0.72, 0.71, 0.7, 0.69, 0.68, 0.67, 0.66, 0.65, 0.64, 0.77, 0.76, 0.75, 0.74,
    0.73, 0.72, 0.71, 0.7, 0.69, 0.68, 0.67
  ),
  diff_var = rep(-5:5, 16),
  case = rep(rep(1:8, 2), each = 11L),
  var = rep(c("x", "n"), each = 88L),
) %>%
  structure(
    class = c(
      "scr_map_seq", "scr_grim_map_seq", "scr_grim_map", "scr_rounding_up_or_down",
      "tbl_df", "tbl", "data.frame"
    )
  )



# Testing -----------------------------------------------------------------

test_that("`grim_map_seq()` works correctly", {
  pigs1 %>% grim_map_seq() %>% expect_equal(pigs1_exp)
  pigs2 %>% grim_map_seq(percent = TRUE) %>% suppressMessages() %>% expect_equal(pigs2_exp)
  pigs1 %>% grim_map_seq(include_reported = TRUE) %>% expect_equal(pigs1_include_reported_exp)
})

