% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scf_ttest.R
\name{scf_ttest}
\alias{scf_ttest}
\title{T-Test of Means using SCF Microdata}
\usage{
scf_ttest(
  design,
  var,
  group = NULL,
  mu = 0,
  alternative = c("two.sided", "less", "greater"),
  conf.level = 0.95
)
}
\arguments{
\item{design}{A \code{scf_mi_survey} object created by \code{\link[=scf_load]{scf_load()}}.}

\item{var}{A one-sided formula specifying a numeric variable (e.g., \code{~income}).}

\item{group}{Optional one-sided formula specifying a binary grouping variable (e.g., \code{~female}).}

\item{mu}{Numeric. Null hypothesis value. Default is \code{0}.}

\item{alternative}{Character. One of \code{"two.sided"} (default), \code{"less"}, or \code{"greater"}.}

\item{conf.level}{Confidence level for the confidence interval. Default is \code{0.95}.}
}
\value{
An object of class \code{scf_ttest} with:
\describe{
\item{results}{A data frame with pooled estimate, standard error, t-statistic, degrees of freedom, p-value, and confidence interval.}
\item{means}{Group-specific means (for two-sample tests only).}
\item{fit}{List describing the test type, null hypothesis, confidence level, and alternative.}
}
}
\description{
Tests whether the mean of a continuous variable differs from a specified
value (one-sample), or whether group means differ across a binary factor
(two-sample). Estimates and standard errors are computed using \code{svymean()}
within each implicate, then pooled using Rubin’s Rules.  Use this function
to test hypotheses about means in the SCF microdata.
}
\examples{
# Do not implement these lines in real analysis:
# Use functions `scf_download()` and `scf_load()`
td <- tempfile("ttest_")
dir.create(td)

src <- system.file("extdata", "scf2022_mock_raw.rds", package = "scf")
file.copy(src, file.path(td, "scf2022.rds"), overwrite = TRUE)
scf2022 <- scf_load(2022, data_directory = td)

# Wrangle data for example: Derive analysis vars
scf2022 <- scf_update(scf2022,
  female = factor(hhsex, levels = 1:2, labels = c("Male","Female")),
  over50 = age > 50
)

# Example for real analysis:  One-sample t-test
scf_ttest(scf2022, ~income, mu = 75000)

# Example for real analysis:  Two-sample t-test
scf_ttest(scf2022, ~income, group = ~female)

# Do not implement these lines in real analysis: Cleanup for package check
unlink(td, recursive = TRUE, force = TRUE)

}
\seealso{
\code{\link[=scf_prop_test]{scf_prop_test()}}, \code{\link[=scf_mean]{scf_mean()}}, \code{\link[=scf_MIcombine]{scf_MIcombine()}}
}
