% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Statistics.R
\name{Cluster_Stats_All_Samples}
\alias{Cluster_Stats_All_Samples}
\title{Calculate Cluster Stats}
\usage{
Cluster_Stats_All_Samples(
  seurat_object,
  group_by_var = deprecated(),
  group.by = "orig.ident",
  order_by_freq = TRUE
)
}
\arguments{
\item{seurat_object}{Seurat object name.}

\item{group_by_var}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} soft-deprecated. See \code{group.by}.}

\item{group.by}{meta data column to classify samples (default = "orig.ident").}

\item{order_by_freq}{logical, whether the data.frame should be ordered by frequency of
identity (default; TRUE), or by cluster/fector order (FALSE).}
}
\value{
A data.frame with rows in order of frequency or cluster order
}
\description{
Calculates both overall and per sample cell number and percentages per cluster based on orig.ident.
}
\examples{
\dontrun{
stats <- Cluster_Stats_All_Samples(seurat_object = object, group.by = "orig.ident")
}

}
\concept{stats}
