% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/makeme_helpers.R
\name{generate_data_summary}
\alias{generate_data_summary}
\title{Generate Appropriate Data Summary Based on Variable Types}
\usage{
generate_data_summary(
  variable_types,
  subset_data,
  dep_crwd,
  indep_crwd,
  args,
  ...
)
}
\arguments{
\item{variable_types}{List with dep and indep variable type information}

\item{subset_data}{Data frame subset for the current crowd}

\item{dep_crwd}{Character vector of dependent variable names for current crowd}

\item{indep_crwd}{Character vector of independent variable names for current crowd}

\item{args}{List of makeme function arguments}

\item{...}{Additional arguments passed to summarization functions}
}
\value{
Data summary object (type depends on variable types):
\itemize{
\item For integer/numeric dep + factor/character indep: calls summarize_int_cat_data()
\item For factor/character dep: calls summarize_cat_cat_data()
\item For mixed types: throws error
}
}
\description{
Internal helper function that routes to the appropriate data summarization
function based on the detected variable types (categorical vs continuous).
}
\keyword{internal}
