% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/draws.R
\name{draws_ci}
\alias{draws_ci}
\alias{draws_ci.rvec}
\alias{draws_ci.rvec_chr}
\title{Credible Intervals from Random Draws}
\usage{
draws_ci(x, width = 0.95, prefix = NULL, na_rm = FALSE)

\method{draws_ci}{rvec}(x, width = 0.95, prefix = NULL, na_rm = FALSE)

\method{draws_ci}{rvec_chr}(x, width = 0.95, prefix = NULL, na_rm = FALSE)
}
\arguments{
\item{x}{An object of class \link[=rvec]{rvec}.}

\item{width}{Width(s) of credible interval(s).
One or more numbers greater than 0
and less than or equal to 1.
Default is \code{0.975}.}

\item{prefix}{String to be added to the
names of columns in the result.
Defaults to name of \code{x}.}

\item{na_rm}{Whether to remove NAs before
calculating summaries. Default is \code{FALSE}.}
}
\value{
A \link[tibble:tibble]{tibble}
with three columns.
}
\description{
Summarise the distribution of random draws
in an rvec, using  credible intervals.
}
\section{Warning}{


It is tempting to assign the results
of a call to \code{draws_ci()} to a
column in a data frame,
as in

\code{my_df$ci <- draws_ci(my_rvec)}

However, creating columns in
this way can corrupt an ordinary data frames.
For safer options,
see the examples below.
}

\examples{
set.seed(0)
m <- rbind(a = rnorm(100, mean = 5, sd = 2),
           b = rnorm(100, mean = -3, sd = 3),
           c = rnorm(100, mean = 0, sd = 20))
x <- rvec(m)
x
draws_ci(x)
draws_ci(x, width = c(0.5, 0.99))
draws_ci(x, prefix = "results")

## results from 'draws_ci'
## assigned to a data frame
library(dplyr)
df <- data.frame(x)

## base R approach
cbind(df, draws_ci(x))

## a tidyverse alternative:
## mutate with no '='
df |> mutate(draws_ci(x))
}
\seealso{
\code{\link[=draws_quantile]{draws_quantile()}} gives more options
for forming quantiles.

Other ways of applying pre-specified functions
across draws are:
\itemize{
\item \code{\link[=draws_all]{draws_all()}}
\item \link{draws_any}
\item \code{\link[=draws_min]{draws_min()}}
\item \code{\link[=draws_max]{draws_max()}}
\item \code{\link[=draws_median]{draws_median()}}
\item \code{\link[=draws_mean]{draws_mean()}}
\item \code{\link[=draws_mode]{draws_mode()}}
\item \code{\link[=draws_sd]{draws_sd()}}
\item \code{\link[=draws_var]{draws_var()}}
\item \code{\link[=draws_cv]{draws_cv()}}
\item \code{\link[=draws_quantile]{draws_quantile()}}
}

Apply arbitrary function across draws:
\itemize{
\item \code{\link[=draws_fun]{draws_fun()}}
}
}
