% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assertions.R
\name{rush_assertions}
\alias{rush_assertions}
\alias{assert_rush}
\alias{assert_rushs}
\alias{assert_rush_worker}
\alias{assert_rush_workers}
\title{Assertion for Rush Objects}
\usage{
assert_rush(rush, null_ok = FALSE)

assert_rushs(rushs, null_ok = FALSE)

assert_rush_worker(worker, null_ok = FALSE)

assert_rush_workers(workers, null_ok = FALSE)
}
\arguments{
\item{rush}{(\link{Rush}).}

\item{null_ok}{(\code{logical(1)}).
If \code{TRUE}, \code{NULL} is allowed.}

\item{rushs}{(list of \link{Rush}).}

\item{worker}{(\link{RushWorker}).}

\item{workers}{(list of \link{RushWorker}).}
}
\value{
Exception if the assertion fails, otherwise the input object invisibly.
}
\description{
Most assertion functions ensure the right class attribute, and optionally additional properties.
If an assertion fails, an exception is raised.
Otherwise, the input object is returned invisibly.
}
\examples{
# This example is not executed since Redis must be installed
\donttest{
   config_local = redux::redis_config()
   rush = rsh(network_id = "test_network", config = config_local)

   assert_rush(rush)
}
}
\keyword{internal}
