\name{mi_rqlm}
\alias{mi_rqlm}
\title{Multiple imputation analysis for modified Poisson and least-squares regressions}
\usage{
mi_rqlm(ice, formula, family=poisson, eform=FALSE, cl=0.95, digits=4)
}
\arguments{
\item{ice}{An output object of \code{mice} function in \code{mice} package.}

\item{formula}{An object of class "formula" (or one that can be coerced to that class): a symbolic description of the model to be fitted.}

\item{family}{A description of the error distribution and link function to be used in the model. \code{gaussian}: Modified least-squares regression. \code{poisson}: Modified Poisson regression.}

\item{eform}{A logical value that specify whether the outcome should be transformed by exponential function (default: \code{FALSE})}

\item{cl}{Confidence level for calculating confidence intervals (default: 0.95)}

\item{digits}{Number of decimal places in the output (default: 4).}
}
\value{
Results of the multiple imputation analysis for modified Poisson and least-squares regressions. For computing covariance matrix estimate, the ordinary Rubin's rule is adapted to the sandwich variance estimates.
\itemize{
\item \code{coef}: Coefficient estimates; transformed to the exponential scale if \code{eform=TRUE}.
\item \code{SE}: Robust standard error estimates for \code{coef}.
\item \code{CL}: Lower limits of confidence intervals.
\item \code{CU}: Upper limits of confidence intervals.
\item \code{df}: Degree of freedom for the t-approximation.
\item \code{P-value}: P-values for the coefficient tests.
}
}
\description{
Multiple imputation analysis for modified Poisson and least-squares regressions is performed for the imputed datasets generated by \code{mice} function in \code{mice} package. For computing covariance matrix estimate, the ordinary Rubin's rule is adapted to the sandwich variance estimates. Its validity is checked by several simulation studies for general GEE applications by Beunckens et al. (2008), Birhanu et al. (2011) and Yoo (2010).}
\references{
Aloisio, K. M., Swanson, S. A., Micali, N., Field, A., and Horton, N. J. (2014). Analysis of partially observed clustered data using generalized estimating equations and multiple imputation. \emph{Stata Journal}, \strong{14}, 863-883.

Beunckens, C., Sotto, C., and Molenberghs., G. (2008). A simulation study comparing weighted estimating equations with multiple imputation based estimating equations for longitudinal binary data. \emph{Computational Statistics and Data Analysis}, \strong{52}, 1533-1548.

Birhanu, T., Molenberghs, G., Sotto, C., and Kenward, M. G. (2011). Doubly robust and multiple-imputation-based generalized estimating equations. \emph{Journal of Biopharmaceutical Statistics}, \strong{21}, 202-225.

Little, R. J., and Rubin, D. B. (2019). \emph{Statistical Analysis with Missing Data}, 3rd edition. New York: Wiley.

Yoo, B. (2010). The impact of dichotomization in longitudinal data analysis: a simulation study. \emph{Pharmaceutical Statistics}, \strong{9}, 298-312.
}
\examples{
library("mice")

data(exdata03)

exdata03$x2 <- factor(exdata03$x2)
exdata03$x3 <- factor(exdata03$x3)
exdata03$x4 <- factor(exdata03$x4)

ice5 <- mice(exdata03,m=5)
# For illustration. m should be >=100.

mi_rqlm(ice5, y ~ x1 + x2 + x3 + x4, family=poisson, eform=TRUE)
# Modifed Poisson regression analysis
# Coefficient estimates are translated to risk ratio scales

mi_rqlm(ice5, y ~ x1 + x2 + x3 + x4, family=gaussian)
# Modifed least-squares regression analysis
}
