% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_phylopic_legend.R
\name{add_phylopic_legend}
\alias{add_phylopic_legend}
\title{Add a PhyloPic legend for a base R plot}
\usage{
add_phylopic_legend(
  x,
  y = NULL,
  legend,
  img = NULL,
  name = NULL,
  uuid = NULL,
  ysize = deprecated(),
  height = NULL,
  color = NA,
  fill = "black",
  ...
)
}
\arguments{
\item{x}{\code{numeric or character}. Either the x coordinate to be used
to position the legend or a keyword accepted by \code{\link[=legend]{legend()}} such as
"topleft", "topright", "bottomleft", and "bottomright".}

\item{y}{\code{numeric}. The y coordinate to be used to position the
legend. Can be \code{NULL} (default) if using keywords in \code{x}.}

\item{legend}{\code{character}. A character vector of the labels to appear
in the legend.}

\item{img}{A \link[grImport2:Picture-class]{Picture} or png array object, e.g.,
from using \code{\link[=get_phylopic]{get_phylopic()}}.}

\item{name}{\code{character}. A taxonomic name to be passed to \code{\link[=get_uuid]{get_uuid()}}.}

\item{uuid}{\code{character}. A valid uuid for a PhyloPic silhouette (such as
that returned by \code{\link[=get_uuid]{get_uuid()}} or \code{\link[=pick_phylopic]{pick_phylopic()}}).}

\item{ysize}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} use the \code{height}
argument instead.}

\item{height}{\code{numeric}. Height of the legend silhouette(s). The width
is determined by the aspect ratio of the original image.}

\item{color}{\code{character}. Color of silhouette outline. If "original" or
NA is specified, the original color of the silhouette outline will be used
(usually the same as "transparent"). To remove the outline, you can set
this to "transparent".}

\item{fill}{\code{character}. Color of silhouette. If "original" is
specified, the original color of the silhouette will be used (usually the
same as "black"). If \code{color} is specified and \code{fill} is NA, \code{color} will be
used as the fill color (for backwards compatibility). To remove the fill,
you can set this to "transparent".}

\item{...}{Additional arguments passed to \code{\link[=legend]{legend()}}.}
}
\description{
Specify existing images, taxonomic names, or PhyloPic uuids to add PhyloPic
silhouettes as a legend to an existing base R plot (like \code{\link[=legend]{legend()}}).
}
\details{
This function can be used to add PhyloPic silhouettes as a legend
to a base R plot. Arguments available in \code{\link[=legend]{legend()}} can be used and
passed via \code{...}. Note that not all arguments in \code{\link[=legend]{legend()}} are
compatible with \code{\link[=add_phylopic_legend]{add_phylopic_legend()}}. These include arguments for
modifying lines (e.g. \code{lty}, \code{lwd}, \code{seg.len}), points (e.g. \code{pch},
\code{pt.lwd}), and shading (e.g. \code{angle} and \code{density}). This is due to
\code{\link[=add_phylopic_legend]{add_phylopic_legend()}} using \code{\link[=add_phylopic_base]{add_phylopic_base()}} to generate the
legend symbols. However, arguments for adjusting the legend appearance
such as text (e.g. \code{cex}), legend box (e.g. \code{bg}), and color (e.g.
\code{border}) are compatible.
}
\examples{
# Get UUIDs
uuids <- get_uuid(name = "Canis lupus", n = 2)
# Generate empty plot
plot(0:10, 0:10, type = "n", main = "Wolves")
# Add data points
add_phylopic_base(uuid = uuids,
  color = "black", fill = c("blue", "green"),
  x = c(2.5, 7.5), y = c(2.5, 7.5), height = 2)
# Add legend
add_phylopic_legend(uuid = uuids, 
  height = 0.5, color = "black", fill = c("blue", "green"), 
  x = "bottomright", legend = c("Wolf 1", "Wolf 2"),
  bg = "lightgrey")
}
