% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bpcPcaTab.R
\name{bpcPcaTab}
\alias{bpcPcaTab}
\title{Principal component analysis of compositional tables based on backwards pivot coordinates}
\usage{
bpcPcaTab(
  X,
  obs.ID = NULL,
  row.factor = NULL,
  col.factor = NULL,
  value = NULL,
  robust = FALSE,
  norm.cat.row = NULL,
  norm.cat.col = NULL
)
}
\arguments{
\item{X}{object of class data.frame with columns corresponding to row and column factors of the respective compositional table, a variable with the values of the composition (positive values only) and a factor with observation IDs.}

\item{obs.ID}{name of the factor variable distinguishing the observations. Needs to be given with the quotation marks.}

\item{row.factor}{name of the variable representing the row factor. Needs to be given with the quotation marks.}

\item{col.factor}{name of the variable representing the column factor. Needs to be given with the quotation marks.}

\item{value}{name of the variable representing the values of the composition. Needs to be given with the quotation marks.}

\item{robust}{if TRUE, the MCD estimate is used. Defaults to FALSE.}

\item{norm.cat.row}{the rationing category of the row factor. If not defined, all pairs are considered. Given in quotation marks.}

\item{norm.cat.col}{the rationing category of the column factor. If not defined, all pairs are considered. Given in quotation marks.}
}
\value{
\item{scores}{array of scores.} 
\item{loadings}{loadings related to the selected backwards coordinates. The names of the rows indicate the type of the respective coordinate 
(rbpb.1 - the first row backwards pivot balance, cbpb.1 - the first column backwards pivot balance and tbpc.1.1 - the first table backwards pivot coordinate) and the logratio or log odds-ratio quantified thereby. 
E.g. cbpb.1_C2.to.C1 would therefore correspond to the logratio between column categories C1 and C2, schematically written log(C2/C1), and tbpc.1.1_R2.to.R1.&.C2.to.C1 would correspond to the log odds-ratio computed from a 2x2 table, 
which is formed by row categories R1 and R2 and columns C1 and C2. See Nesrstova et al. (2023) for details.} 
\item{loadings.clr}{loadings in the clr space. The names of the rows indicate the position of respective part in the clr representation of the compositional table, labeled as row.category_column.category.} 
\item{sdev}{standard deviations of the principal components.}
\item{center}{means of the selected backwards coordinates.}
\item{center.clr}{means of the clr coordinates.}
\item{n.obs}{number of observations.}
}
\description{
Performs classical or robust principal component analysis on a set of compositional tables, based on backwards pivot coordinates. Returns the result related to pairwise row and column balances and four-part log odds-ratios. The loadings in the clr space are available as well.
}
\details{
bpcPcaTab

The set of compositional tables is repeatedly expressed in a set of backwards logratio coordinates, 
when each set highlights different combination of pairs of row and column factor categories, as detailed in Nesrstova et al. (2023). 
For each set, robust or classical principal component analysis is performed and loadings respective to the first row, column and odds-ratio backwards pivot coordinates are stored. 
The procedure results in matrix of scores (invariant to the specific coordinate system), clr loading matrix and matrix with loadings related to the selected backwards coordinates.
}
\examples{
data(manu_abs)
manu_abs$output <- as.factor(manu_abs$output)
manu_abs$isic <- as.factor(manu_abs$isic)

# classical estimation with all pairwise balances and four-part ORs:
res.cla <- bpcPcaTab(manu_abs, obs.ID = "country", row.factor = "output", 
col.factor = "isic", value = "value")
summary(res.cla)
biplot(res.cla)
head(res.cla$scores)
res.cla$loadings
res.cla$loadings.clr

# classical estimation with LAB anf 155 as rationing categories
res.cla.select <- bpcPcaTab(manu_abs, obs.ID = "country", row.factor = "output", 
col.factor = "isic", value = "value", norm.cat.row = "LAB", norm.cat.col = "155")
summary(res.cla.select)
biplot(res.cla.select)
head(res.cla.select$scores)
res.cla.select$loadings
res.cla.select$loadings.clr

# robust estimation with all pairwise balances and four-part ORs:
res.rob <- bpcPcaTab(manu_abs, obs.ID = "country", row.factor = "output", 
col.factor = "isic", value = "value", robust = TRUE)
summary(res.rob)
biplot(res.rob)
head(res.rob$scores)
res.rob$loadings
res.rob$loadings.clr
}
\references{
Nesrstova, V., Jaskova, P., Pavlu, I., Hron, K., Palarea-Albaladejo, J., Gaba, A., Pelclova, J., Facevicova, K. (2023). Simple enough, but not simpler: Reconsidering additive logratio coordinates in compositional analysis. Submitted
}
\seealso{
\code{\link{bpcTabWrapper}} 
\code{\link{bpcPca}}
\code{\link{bpcRegTab}}
}
\author{
Kamila Facevicova
}
\keyword{multivariate}
