% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calendars.R
\name{fixed_day}
\alias{fixed_day}
\title{Set a holiday on a Fixed Day}
\usage{
fixed_day(month, day, weight = 1, validity = NULL)
}
\arguments{
\item{month, day}{the month and the day of the fixed day to add.}

\item{weight}{weight associated to the holiday.}

\item{validity}{validity period: either \code{NULL} (full sample) or a named list
with \code{"start"} and/or "end" dates in the format \code{"YYYY-MM-DD"}.}
}
\value{
returns an object of class \code{c("JD3_FIXEDDAY","JD3_HOLIDAY")}
}
\description{
It creates a holiday falling on a fixed day each year, with an optional
weight and period of validity, like Christmas which is always celebrated on
December 25th.
}
\examples{
\dontshow{if (current_java_version >= minimal_java_version) withAutoprint(\{ # examplesIf}
day <- fixed_day(7, 21, .9)
day # July 21st, with weight=0.9, on the whole sample
day <- fixed_day(12, 25, .5, validity = list(start = "2010-01-01"))
day # December 25th, with weight=0.5, from January 2010
day <- fixed_day(12, 25, .5, validity = list(start = "1968-02-01", end = "2010-01-01"))
day # December 25th, with weight=0.9, from February 1968 until January 2010
\dontshow{\}) # examplesIf}
}
\references{
More information on calendar correction in JDemetra+ online documentation:
\url{https://jdemetra-new-documentation.netlify.app/a-calendar-correction}
}
\seealso{
\code{\link{national_calendar}}, \code{\link{special_day}},\code{\link{easter_day}}
}
