/*
 * Decompiled with CFR 0.152.
 */
package jdplus.sa.base.core.diagnostics;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import jdplus.sa.base.api.SaDiagnosticsFactory;
import jdplus.sa.base.core.diagnostics.AdvancedResidualSeasonalityDiagnostics;
import jdplus.sa.base.core.diagnostics.AdvancedResidualSeasonalityDiagnosticsConfiguration;
import jdplus.sa.base.core.diagnostics.GenericSaTests;
import jdplus.toolkit.base.api.processing.Diagnostics;
import lombok.NonNull;

public class AdvancedResidualSeasonalityDiagnosticsFactory<R>
implements SaDiagnosticsFactory<AdvancedResidualSeasonalityDiagnosticsConfiguration, R> {
    public static final String NAME = "Residual seasonality tests";
    public static final String DESC = "Residual seasonality tests";
    static final String QS_SA = "Qs test on SA";
    static final String QS_I = "Qs test on I";
    static final String FTEST_SA = "F-Test on SA (seasonal dummies)";
    static final String FTEST_I = "F-Test on I (seasonal dummies)";
    static final List<String> ALL = Collections.unmodifiableList(Arrays.asList("Qs test on SA", "Qs test on I", "F-Test on SA (seasonal dummies)", "F-Test on I (seasonal dummies)"));
    private final AdvancedResidualSeasonalityDiagnosticsConfiguration config;
    private final Function<R, GenericSaTests> extractor;

    public AdvancedResidualSeasonalityDiagnosticsFactory(@NonNull AdvancedResidualSeasonalityDiagnosticsConfiguration config, @NonNull Function<R, GenericSaTests> extractor) {
        if (config == null) {
            throw new NullPointerException("config is marked non-null but is null");
        }
        if (extractor == null) {
            throw new NullPointerException("extractor is marked non-null but is null");
        }
        this.config = config;
        this.extractor = extractor;
    }

    public AdvancedResidualSeasonalityDiagnosticsConfiguration getConfiguration() {
        return this.config;
    }

    public AdvancedResidualSeasonalityDiagnosticsFactory<R> with(@NonNull AdvancedResidualSeasonalityDiagnosticsConfiguration config) {
        if (config == null) {
            throw new NullPointerException("config is marked non-null but is null");
        }
        return new AdvancedResidualSeasonalityDiagnosticsFactory<R>(config, this.extractor);
    }

    public String getName() {
        return "Residual seasonality tests";
    }

    public List<String> getTestDictionary() {
        return ALL.stream().map(s -> s + ":2").collect(Collectors.toList());
    }

    public Diagnostics of(R rslts) {
        return AdvancedResidualSeasonalityDiagnostics.of(this.config, this.extractor.apply(rslts));
    }

    public SaDiagnosticsFactory.Scope getScope() {
        return SaDiagnosticsFactory.Scope.Decomposition;
    }

    public int getOrder() {
        return 0;
    }
}

