/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.ssf.univariate;

import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.api.data.DoubleSeqCursor;
import jdplus.toolkit.base.core.data.DataBlock;
import jdplus.toolkit.base.core.data.DataBlockIterator;
import jdplus.toolkit.base.core.math.matrices.FastMatrix;
import jdplus.toolkit.base.core.ssf.ISsfDynamics;
import jdplus.toolkit.base.core.ssf.ISsfLoading;
import jdplus.toolkit.base.core.ssf.univariate.DefaultFilteringResults;
import jdplus.toolkit.base.core.ssf.univariate.ISsf;

public class FastFilter {
    private final VarianceFilterProvider vf;
    private final ISsf ssf;
    private final ISsfLoading loading;
    private final ISsfDynamics dynamics;
    private FastMatrix states;
    private DataBlock tmp;
    private DataBlockIterator scols;

    public FastFilter(ISsf ssf, DefaultFilteringResults frslts) {
        this.ssf = ssf;
        this.vf = VarianceFilterProvider.of(frslts);
        this.loading = ssf.measurement().loading();
        this.dynamics = ssf.dynamics();
    }

    public boolean filter(FastMatrix x) {
        int m;
        int n = this.vf.size();
        if (n < (m = x.getRowsCount())) {
            return false;
        }
        int dim = this.ssf.getStateDim();
        this.states = FastMatrix.make(dim, x.getColumnsCount());
        this.prepareTmp();
        DataBlockIterator rows = x.rowsIterator();
        int pos = 0;
        while (pos < m && rows.hasNext()) {
            this.iterate(pos++, rows.next());
        }
        return true;
    }

    private void prepareTmp() {
        int nvars = this.states.getColumnsCount();
        this.tmp = DataBlock.make(nvars);
        this.scols = this.states.columnsIterator();
    }

    private void iterate(int i, DataBlock row) {
        boolean missing = this.vf.isMissing(i);
        double f = this.vf.errorVariance(i);
        this.loading.ZM(i, this.states, this.tmp);
        row.sub(this.tmp);
        if (f > 0.0) {
            if (!missing) {
                DataBlock C = this.vf.M(i);
                this.scols.reset();
                DoubleSeqCursor.OnMutable r = row.cursor();
                while (this.scols.hasNext()) {
                    this.scols.next().addAY(r.getAndNext() / f, C);
                }
            }
            row.mul(1.0 / Math.sqrt(f));
        } else {
            row.apply(q -> Math.abs(q) > 1.0E-9 ? Double.NaN : 0.0);
        }
        this.dynamics.TM(i, this.states);
    }

    public void apply(DoubleSeq in, DataBlock out) {
        int dim = this.ssf.getStateDim();
        int n = in.length();
        DataBlock state = DataBlock.make(dim);
        int pos = 0;
        int opos = 0;
        do {
            boolean missing;
            if (!(missing = this.vf.isMissing(pos))) {
                double f = this.vf.errorVariance(pos);
                double e = in.get(pos) - this.loading.ZX(pos, state);
                if (f > 0.0) {
                    out.set(opos++, e / Math.sqrt(f));
                    DataBlock C = this.vf.M(pos);
                    state.addAY(e / f, C);
                } else {
                    out.set(opos++, Math.abs(e) > 1.0E-9 ? Double.NaN : 0.0);
                }
            }
            this.dynamics.TX(pos++, state);
        } while (pos < n);
    }

    public int getOutputLength(int inputLength) {
        int n = 0;
        int imax = inputLength;
        int end = this.vf.size();
        if (imax > end) {
            return -1;
        }
        for (int i = 0; i < imax; ++i) {
            double v = this.vf.errorVariance(i);
            if (this.vf.isMissing(i) || v == 0.0) continue;
            ++n;
        }
        return n;
    }

    public static interface VarianceFilterProvider {
        public int size();

        public boolean isMissing(int var1);

        public double errorVariance(int var1);

        public DataBlock M(int var1);

        public static VarianceFilterProvider of(final DefaultFilteringResults fr2) {
            return new VarianceFilterProvider(){

                @Override
                public int size() {
                    return fr2.size();
                }

                @Override
                public boolean isMissing(int pos) {
                    return fr2.isMissing(pos);
                }

                @Override
                public double errorVariance(int pos) {
                    return fr2.errorVariance(pos);
                }

                @Override
                public DataBlock M(int pos) {
                    return fr2.M(pos);
                }
            };
        }
    }
}

