% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bures-wasserstein.R
\name{bures_wasserstein_log}
\alias{bures_wasserstein_log}
\title{Compute the Bures-Wasserstein Logarithm}
\usage{
bures_wasserstein_log(sigma, lambda, validate = FALSE)
}
\arguments{
\item{sigma}{A symmetric positive-definite matrix of class \code{dppMatrix}, representing the reference point.}

\item{lambda}{A symmetric positive-definite matrix of class \code{dppMatrix}, representing the target point.}

\item{validate}{A logical value indicating whether to validate input arguments. Default is FALSE.}
}
\value{
A symmetric matrix of class \code{dspMatrix}, representing the tangent space image of \code{lambda} at \code{sigma}.
}
\description{
This function computes the Riemannian logarithmic map using the Bures-Wasserstein metric for symmetric positive-definite matrices.
}
