% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subset_surveys.R
\name{subset_surveys}
\alias{subset_surveys}
\alias{subset_waves}
\alias{subset_save_surveys}
\title{Subset and optionally harmonize surveys}
\usage{
subset_surveys(
  survey_list,
  survey_paths = NULL,
  rowid = "rowid",
  subset_name = "subset",
  subset_vars = NULL,
  crosswalk_table = NULL,
  import_path = NULL,
  export_path = NULL
)

subset_waves(waves, subset_vars = NULL)

subset_save_surveys(
  crosswalk_table,
  subset_name = "subset",
  survey_list = NULL,
  subset_vars = NULL,
  survey_paths = NULL,
  import_path = NULL,
  export_path = NULL
)
}
\arguments{
\item{survey_list}{A list of survey objects created by
[read_surveys()]. If `NULL`, surveys are read from disk.}

\item{survey_paths}{A character vector of full file paths to survey files.
Used when `survey_list` is `NULL`.}

\item{rowid}{Name of the unique observation identifier column.
Defaults to `"rowid"`.}

\item{subset_name}{Character string appended to filenames of
subsetted surveys. Defaults to `"subset"`.}

\item{subset_vars}{Character vector of variable names to retain.
If `NULL`, all variables are retained.}

\item{crosswalk_table}{Optional crosswalk table created with
[crosswalk_table_create()]. If supplied, variables are selected
per survey based on `var_name_orig`, and variable names may be
harmonized using `var_name_target`.}

\item{import_path}{Optional directory containing survey files.
Used to resolve filenames when subsetting from disk.}

\item{export_path}{Optional directory where subsetted surveys
are saved as `.rds` files. If `NULL`, surveys are returned in memory.}

\item{waves}{A list of surveys imported with [read_surveys()].}
}
\value{
Either:
* a list of subsetted survey objects (if `export_path = NULL`), or
* a character vector of filenames written to `export_path`.
}
\description{
Subset one or more surveys by retaining a specified set of variables.
Subsetting can be performed either on surveys already loaded in memory
or directly from survey files on disk.

If a crosswalk table is supplied, variables are selected based on the
variables listed for each survey in the crosswalk, and variable names
can optionally be harmonized using `var_name_target`.

This function replaces the deprecated helpers
[subset_waves()] and [subset_save_surveys()].
}
\details{
The function supports multiple workflows:

* **In-memory subsetting** using `survey_list`
* **File-based subsetting** using `survey_paths` or `import_path`
* **Crosswalk-driven subsetting**, where variables are selected
  per survey using a crosswalk table created by
  [crosswalk_table_create()]

If `export_path` is provided, subsetted surveys are written to disk
as `.rds` files. Otherwise, subsetted surveys are returned in memory.
}
\examples{
examples_dir <- system.file("examples", package = "retroharmonize")
survey_files <- dir(examples_dir, pattern = "\\\\.rds$")

surveys <- read_surveys(
  file.path(examples_dir, survey_files),
  export_path = NULL
)

subset_surveys(
  survey_list = surveys,
  subset_vars = c("rowid", "isocntry", "qa10_1", "qa14_1"),
  subset_name = "example_subset"
)

}
\seealso{
[crosswalk_table_create()],
[harmonize_survey_variables()],
[read_surveys()]
}
\concept{subsetting functions}
