% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aaa.R
\name{mime_type_from_file}
\alias{mime_type_from_file}
\alias{mime_type_info}
\title{Get the mime type associated with a file based on its file extension}
\usage{
mime_type_from_file(filename)

mime_type_info(type)
}
\arguments{
\item{filename}{The name of the file to query}

\item{type}{The mime type to get additional information on}
}
\value{
A data.frame with a row for each match and the columns:
\itemize{
\item \emph{name} The mime type
\item \emph{extensions} The extensions commonly associated with the mime type
\item \emph{charset} The character set used for the type, if any
\item \emph{compressible} Is the type known to be compressible
\item \emph{source} The source of the mime type information
}
}
\description{
While file extensions are not universally guaranteed to be tied to the
content of a file, they are often indicative of the content to the degree
that they can be used if the content type is missing. \code{mime_type_from_file}
gives access to the huge database of mime types and their file extensions
that reqres contains. \code{mime_type_info()} provides the same information but
rather than basing the search on a file, you provide the known mime type
directly
}
\keyword{internal}
