% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/report.BFBayesFactor.R
\name{report.BFBayesFactor}
\alias{report.BFBayesFactor}
\alias{report_statistics.BFBayesFactor}
\title{Reporting \code{BFBayesFactor} objects from the \code{BayesFactor} package}
\usage{
\method{report}{BFBayesFactor}(x, h0 = "H0", h1 = "H1", ...)

\method{report_statistics}{BFBayesFactor}(x, table = NULL, ...)
}
\arguments{
\item{x}{An object of class \code{BFBayesFactor}.}

\item{h0, h1}{Names of the null and alternative hypotheses.}

\item{...}{Other arguments to be passed to \link[effectsize:interpret_bf]{effectsize::interpret_bf} and \link[insight:format_bf]{insight::format_bf}.}

\item{table}{A \code{parameters} table (this argument is meant for internal use).}
}
\description{
Interpretation of the Bayes factor output from the \code{BayesFactor} package.
}
\examples{
\dontshow{if (requireNamespace("BayesFactor", quietly = TRUE)) withAutoprint(\{ # examplesIf}
\donttest{
library(BayesFactor)

rez <- BayesFactor::ttestBF(iris$Sepal.Width, iris$Sepal.Length)
report_statistics(rez, exact = TRUE) # Print exact BF
report(rez, h0 = "the null hypothesis", h1 = "the alternative")

rez <- BayesFactor::correlationBF(iris$Sepal.Width, iris$Sepal.Length)
report(rez)
}
\dontshow{\}) # examplesIf}
}
