% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rl_scientific_name.R
\name{rl_scientific_name}
\alias{rl_scientific_name}
\title{IUCN Red List taxa by scientific name}
\usage{
rl_scientific_name(
  genus_name,
  species_name,
  infra_name = NULL,
  subpopulation_name = NULL
)
}
\arguments{
\item{genus_name}{Character. The genus name (required).}

\item{species_name}{Character. The species name (required).}

\item{infra_name}{Character. The infraspecific name (optional).}

\item{subpopulation_name}{Character. The subpopulation name (optional).}
}
\value{
A tibble (class \code{tbl_df}, \code{tbl}, \code{data.frame}) where each column represents a unique API response JSON key.
The tibble contains assessment data for the specified taxon, including taxon details.
}
\description{
Retrieve species assessments using scientific names (Latin binomials).
Returns summary assessment data including both latest and historic assessments.
}
\examples{
\dontrun{
# Get assessments for Panthera leo (lion)
rl_scientific_name(genus_name = "Panthera", species_name = "leo")
}
}
