% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/to_txt.R
\name{rdd_to_txt}
\alias{rdd_to_txt}
\title{Dump Package Source, Documentationm and Vignettes into Plain Text}
\usage{
rdd_to_txt(
  pkg,
  file = NULL,
  content = "all",
  force_fetch = FALSE,
  version = NULL,
  keep_files = "none",
  cache_path = getOption("rdocdump.cache_path"),
  repos = getOption("rdocdump.repos", getOption("repos"))
)
}
\arguments{
\item{pkg}{A \code{character} string specifying the package. This can be:
\itemize{
\item an installed package name,
\item a full path to a package source directory,
\item a full path to a package archive file (tar.gz), or
\item a package name not installed (which will then be downloaded from CRAN).
}}

\item{file}{Optional. Save path for the output text file. If set, the function will return the path to the file instead of the combined text. Defaults to \code{NULL}.}

\item{content}{A character vector specifying which components to include in the output.
Possible values are:
\itemize{
\item \code{"all"}: Include Rd documentation, vignettes, and R source code (default).
\item \code{"docs"}: Include only the Rd documentation.
\item \code{"vignettes"}: Include only the vignettes.
\item \code{"code"}: Include only the R source code. When extracting code for non-installed packages, the function will not include roxygen2 documentation, as the documentation can be imported from the Rd files. If you want to extract the R source code with the roxygen2 documentation, use \code{\link{rdd_extract_code}} and set \code{include_roxygen} to \code{TRUE}.
}
You can specify multiple options (e.g., \code{c("docs", "code")} to include both documentation and source code).}

\item{force_fetch}{\code{logical}. If \code{TRUE}, the package source will be fetched from CRAN as a tar.gz archive even if the package is already installed locally. Default is \code{FALSE}, but when \code{version} is specified, it will be set to \code{TRUE}.}

\item{version}{Optional. A \code{character} string specifying the package version to fetch from CRAN. If not provided, the latest version will be used.}

\item{keep_files}{A \code{character} value controlling whether temporary files should be kept.
Possible values are:
\itemize{
\item \code{"none"}: Delete both the tar.gz archive and the extracted files (default).
\item \code{"tgz"}: Keep only the tar.gz archive.
\item \code{"extracted"}: Keep only the extracted files.
\item \code{"both"}: Keep both the tar.gz archive and the extracted files.
}}

\item{cache_path}{A \code{character} string specifying the directory where kept temporary files will be stored.
By default, it uses the value of \code{getOption("rdocdump.cache_path")} which sets the cache directory to the temporary directory of the current R session.}

\item{repos}{A \code{character} vector of repository URLs. By default, it uses the value of \code{getOption("rdocdump.repos")} which sets the repository URLs to the default R repositories and is itself set to \code{c("CRAN" = "https://cloud.r-project.org")} on package load to prevent accidental downloads of pre-built packages from Posit Package Manager and R Universe.}
}
\value{
A single string containing the combined package documentation, vignettes, and/or code as specified by the \code{content} argument.
If the \code{file} argument is set, returns the path to the file.
}
\description{
This function produces a single text output for an R package by processing its documentation (Rd files from the package source or the documentation from already installed packages), vignettes, and/or R source code.
}
\examples{
# Extract documentation for built-in `stats` package (both docs and vignettes).
docs <- rdd_to_txt("splines")
cat(substr(docs, 1, 500))

\donttest{
# set cache directory for `rdocdump`
rdd_set_cache_path(paste0(tempdir(), "/rdocdump_cache"))

# Extract only documentation for rJavaEnv by downloading its source from CRAN
docs <- rdd_to_txt(
  "rJavaEnv",
  force_fetch = TRUE,
  content = "docs",
  repos = c("CRAN" = "https://cran.r-project.org")
)
lines <- unlist(strsplit(docs, "\n"))
# Print the first 3 lines
cat(head(lines, 3), sep = "\n")
# Print the last 3 lines
cat(tail(lines, 3), sep = "\n")

# clean cache directory
unlink(getOption("rdocdump.cache_path"), recursive = TRUE, force = TRUE)
}

}
