% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_code.R
\name{extract_code_source}
\alias{extract_code_source}
\title{Helper function to extract code from package source files.
This function reads all \code{.R} files in the \code{R} directory and optionally includes files from the \code{tests} directory.
It can also exclude roxygen2 documentation lines.}
\usage{
extract_code_source(pkg_path, include_tests = FALSE, include_roxygen = FALSE)
}
\arguments{
\item{pkg_path}{Path to the package source directory.}

\item{include_tests}{\code{logical}. If \code{TRUE}, for non-installed packages, the function will also include R source code from the \code{tests} directory. Defaults to \code{FALSE}.}

\item{include_roxygen}{\code{logical}. If \code{TRUE}, roxygen2 documentation lines (lines starting with "#'") from R files will be included in the output. Defaults to \code{FALSE}.}
}
\value{
A single string containing the source code from the package's R files.
}
\description{
Helper function to extract code from package source files.
This function reads all \code{.R} files in the \code{R} directory and optionally includes files from the \code{tests} directory.
It can also exclude roxygen2 documentation lines.
}
\keyword{internal}
