% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/family-monarith.R, R/op-cdo-monadd.R,
%   R/op-cdo-mondiv.R, R/op-cdo-monmul.R, R/op-cdo-monsub.R
\name{monarith}
\alias{monarith}
\alias{cdo_monadd}
\alias{cdo_mondiv}
\alias{cdo_monmul}
\alias{cdo_monsub}
\title{Monthly arithmetic}
\usage{
cdo_monadd(ifile1, ifile2, ofile = NULL)

cdo_mondiv(ifile1, ifile2, ofile = NULL)

cdo_monmul(ifile1, ifile2, ofile = NULL)

cdo_monsub(ifile1, ifile2, ofile = NULL)
}
\arguments{
\item{ifile1, ifile2}{Strings with the path to the input files.}

\item{ofile}{String with the path to the output file.}
}
\value{
Operators that output one or more files return a character vector to the
output files.

Operators that output an indefinite number of files return a string with the
basename of the files.

Operators that don't return filenames return a character vector with the
string output.
}
\description{
This module performs simple arithmetic of a time series and one timestep with the same month and year. For each field in infile1 the corresponding field of the timestep in infile2 with the same month and year is used. The input files need to have the same structure with the same variables. Usually infile2 is generated by an operator of the module MONSTAT.
}
\details{
\if{html}{\out{<div class="sourceCode">}}\preformatted{monadd  Add monthly time series
        Adds a time series and a monthly time series.
monsub  Subtract monthly time series
        Subtracts a time series and a monthly time series.
monmul  Multiply monthly time series
        Multiplies a time series and a monthly time series.
mondiv  Divide monthly time series
        Divides a time series and a monthly time series.
}\if{html}{\out{</div>}}
}
