% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/family-change.R, R/op-cdo-chcode.R,
%   R/op-cdo-chlevel.R, R/op-cdo-chlevelc.R, R/op-cdo-chlevelv.R,
%   R/op-cdo-chname.R, R/op-cdo-chparam.R, R/op-cdo-chunit.R
\name{change}
\alias{change}
\alias{cdo_chcode}
\alias{cdo_chlevel}
\alias{cdo_chlevelc}
\alias{cdo_chlevelv}
\alias{cdo_chname}
\alias{cdo_chparam}
\alias{cdo_chunit}
\title{Change field header}
\usage{
cdo_chcode(
  ifile,
  code = NULL,
  oldcode = NULL,
  newcode = NULL,
  oldparam = NULL,
  newparam = NULL,
  name = NULL,
  oldname = NULL,
  newname = NULL,
  oldlev = NULL,
  newlev = NULL,
  ofile = NULL
)

cdo_chlevel(
  ifile,
  code = NULL,
  oldcode = NULL,
  newcode = NULL,
  oldparam = NULL,
  newparam = NULL,
  name = NULL,
  oldname = NULL,
  newname = NULL,
  oldlev = NULL,
  newlev = NULL,
  ofile = NULL
)

cdo_chlevelc(
  ifile,
  code = NULL,
  oldcode = NULL,
  newcode = NULL,
  oldparam = NULL,
  newparam = NULL,
  name = NULL,
  oldname = NULL,
  newname = NULL,
  oldlev = NULL,
  newlev = NULL,
  ofile = NULL
)

cdo_chlevelv(
  ifile,
  code = NULL,
  oldcode = NULL,
  newcode = NULL,
  oldparam = NULL,
  newparam = NULL,
  name = NULL,
  oldname = NULL,
  newname = NULL,
  oldlev = NULL,
  newlev = NULL,
  ofile = NULL
)

cdo_chname(
  ifile,
  code = NULL,
  oldcode = NULL,
  newcode = NULL,
  oldparam = NULL,
  newparam = NULL,
  name = NULL,
  oldname = NULL,
  newname = NULL,
  oldlev = NULL,
  newlev = NULL,
  ofile = NULL
)

cdo_chparam(
  ifile,
  code = NULL,
  oldcode = NULL,
  newcode = NULL,
  oldparam = NULL,
  newparam = NULL,
  name = NULL,
  oldname = NULL,
  newname = NULL,
  oldlev = NULL,
  newlev = NULL,
  ofile = NULL
)

cdo_chunit(
  ifile,
  code = NULL,
  oldcode = NULL,
  newcode = NULL,
  oldparam = NULL,
  newparam = NULL,
  name = NULL,
  oldname = NULL,
  newname = NULL,
  oldlev = NULL,
  newlev = NULL,
  ofile = NULL
)
}
\arguments{
\item{ifile}{String with the path to the input file.}

\item{code}{INTEGER - Code number}

\item{oldcode}{INTEGER - Pairs of old and new code numbers}

\item{newcode}{INTEGER - Pairs of old and new code numbers}

\item{oldparam}{STRING - Pairs of old and new parameter identifiers}

\item{newparam}{STRING - Pairs of old and new parameter identifiers}

\item{name}{STRING - Variable name}

\item{oldname}{STRING - Pairs of old and new variable names}

\item{newname}{STRING - Pairs of old and new variable names}

\item{oldlev}{FLOAT - Old level}

\item{newlev}{FLOAT - New level}

\item{ofile}{String with the path to the output file.}
}
\value{
Operators that output one or more files return a character vector to the
output files.

Operators that output an indefinite number of files return a string with the
basename of the files.

Operators that don't return filenames return a character vector with the
string output.
}
\description{
This module reads fields from infile, changes some header values and writes the results to outfile. The kind of changes depends on the chosen operator.
}
\details{
\if{html}{\out{<div class="sourceCode">}}\preformatted{chcode    Change code number
          Changes some user given code numbers to new user given values.
chparam   Change parameter identifier
          Changes some user given parameter identifiers to new user given values.
chname    Change variable or coordinate name
          Changes some user given variable or coordinate names to new user given names.
chunit    Change variable unit
          Changes some user given variable units to new user given units.
chlevel   Change level
          Changes some user given levels to new user given values.
chlevelc  Change level of one code
          Changes one level of a user given code number.
chlevelv  Change level of one variable
          Changes one level of a user given variable name.
}\if{html}{\out{</div>}}
}
