% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apl_auth.R
\name{apl_auth}
\alias{apl_auth}
\title{Apple Ads Authorization}
\usage{
apl_auth(
  client_id = Sys.getenv("APL_CLIENT_ID"),
  team_id = Sys.getenv("APL_TEAM_ID"),
  key_id = Sys.getenv("APL_KEY_ID"),
  private_key_path = Sys.getenv("APL_PRIVATE_KEY_PATH"),
  account_name = Sys.getenv("APL_ACCOUNT_NAME"),
  cache_path = rappdirs::site_data_dir("rappleads")
)
}
\arguments{
\item{client_id}{You receive your clientId when you upload a public key.}

\item{team_id}{The client secret is a JWT that you create and sign with your private key.}

\item{key_id}{The value is your keyId that returns when you upload a public key.}

\item{private_key_path}{Path to the \code{.pem} file containing your private key.}

\item{account_name}{Your apple ads account name}

\item{cache_path}{Path to the directory where cached authentication data will be stored.}
}
\value{
character with access_token
}
\description{
Apple Ads Authorization
}
\details{
This implementation process guides you through the following steps:
\enumerate{
\item Invite users with API permissions.
\item Generate a private-public key pair.
\item Extract a public key from your persisted private key.
\item Upload a public key.
\item Set system environments variables.
\item Request an access token.
}
\subsection{Generate a Private Key}{

API users need to create a private key. If you’re using MacOS or a UNIX-like operating system, OpenSSL works natively. If you’re on a Windows platform, you need to download \href{https://www.openssl.org/}{OpenSSL}.
\verb{openssl ecparam -genkey -name prime256v1 -noout -out private-key.pem}
}

\subsection{Extract a Public Key}{

\verb{openssl ec -in private-key.pem -pubout -out public-key.pem}
Open the public-key.pem file in a text editor and copy the public key, including the begin and end lines.
}

\subsection{Upload a Public Key}{

Follow these steps to upload your public key:
\enumerate{
\item From the Ads UI, choose Account Settings > API. Paste the key created in the above section into the Public Key field.
\item Click Save. A group of credentials displays as a code block above the public key field. Use your clientId, teamId, and keyId to create a client secret.
}
}

\subsection{Set system environments variables}{

Run \code{usethis::edit_r_environ()} and set variables:
\itemize{
\item APL_CLIENT_ID
\item APL_TEAM_ID
\item APL_KEY_ID
\item APL_PRIVATE_KEY_PATH
\item APL_ACCOUNT_NAME
}
}

\subsection{Request an access token.}{

Once the environment variables listed above are set, no further action is required from you — any function from the package will automatically request and refresh the access token when executed.

For more information see \href{https://developer.apple.com/documentation/apple_ads/implementing-oauth-for-the-apple-search-ads-api}{API Oauth documentation}.
}
}
