% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidy.r
\name{tidy.rdt}
\alias{tidy.rdt}
\alias{tidy.srt}
\alias{tidy.rdpmedian}
\alias{tidy.pmedian}
\title{Coerce to a data frame}
\usage{
\method{tidy}{rdt}(x, ...)

\method{tidy}{srt}(x, ...)

\method{tidy}{rdpmedian}(x, ...)

\method{tidy}{pmedian}(x, ...)
}
\arguments{
\item{x}{Objects returned by:
\itemize{
\item \code{\link[=rdt]{rdt()}} or \code{\link[=rdt2]{rdt2()}}
\item \code{\link[=srt]{srt()}} or \code{\link[=srt2]{srt2()}}
\item \code{\link[=rdpmedian]{rdpmedian()}} or \code{\link[=rdpmedian2]{rdpmedian2()}}
\item \code{\link[=pmedian]{pmedian()}} or \code{\link[=pmedian2]{pmedian2()}}
}}

\item{...}{Unused arguments.}
}
\value{
\code{tbl_df}
}
\description{
Coerce objects to a 'tibble' data frame in the style of \code{broom::tidy()}.
}
\examples{
#----------------------------------------------------------------------------
# tidy() examples
#----------------------------------------------------------------------------
library(rankdifferencetest)

# Use example data from Kornbrot (1990)
data <- kornbrot_table1

rdt(
  data = data,
  formula = placebo ~ drug,
  conf_level = 0.95,
  alternative = "two.sided",
  distribution = "asymptotic",
  zero_method = "wilcoxon",
  correct = FALSE
) |>
  tidy()

rdpmedian(
  data = data,
  formula = placebo ~ drug,
  conf_level = 0.95
) |>
  tidy()

}
