% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quest_functions.R
\name{change_by}
\alias{change_by}
\title{Change Scores from a Numeric Vector by Group}
\usage{
change_by(x, grp, n, undefined = NA)
}
\arguments{
\item{x}{numeric vector.}

\item{grp}{list of atomic vector(s) and/or factor(s) (e.g., data.frame),
which each have same length as \code{x}. It can also be an atomic vector or
factor, which will then be made the first element of a list internally.}

\item{n}{integer vector with length 1. Specifies how the change score is
calculated. If \code{n} is positive, then the change score is calculated
from lead - original; if \code{n} is negative, then the change score is
calculated from original - lag. The magnitude of \code{n} determines how
many rows are shifted for the lead/lag within the calculation. See details
of \code{\link{shift_by}}.}

\item{undefined}{atomic vector with length 1 (probably makes sense to be the
same typeof as \code{x}). Specifies what to insert for undefined values
after the shifting takes place. See details of \code{\link{shift_by}}.}
}
\value{
an atomic vector of the same length as \code{x} that is the change
  score by group. If \code{x} and \code{undefined} are different typeofs,
  then the return will be coerced to the more complex typoof (i.e., complex
  to simple: character, double, integer, logical).
}
\description{
\code{change_by} creates a change score (aka difference score) from a numeric
vector separately for each group. It is assumed that the vector is already
sorted within each group by time such that the first element for that group
is earliest in time and the last element for that group is the latest in
time.
}
\details{
It is recommended to use \code{L} when specifying \code{n} to prevent
problems with floating point numbers. \code{shift_by} tries to circumvent
this issue by a call to \code{round} within \code{shift_by} if \code{n} is
not an integer; however that is not a complete fail safe. The problem is that
\code{as.integer(n)} implicit in \code{shift_by} truncates rather than
rounds. See details of \code{\link{shift_by}}.
}
\examples{
change_by(x = ChickWeight[["Time"]], grp = ChickWeight[["Chick"]], n = -1L)
tmp_nm <- c("vs","am") # multiple grouping vectors
change_by(x = mtcars[["disp"]], grp = mtcars[tmp_nm], n = +1L)
tmp_nm <- c("Type","Treatment") # multiple grouping vectors
change_by(x = as.data.frame(CO2)[["uptake"]], grp = as.data.frame(CO2)[tmp_nm], n = 2L)
}
\seealso{
\code{\link{changes_by}}
   \code{\link{change}}
   \code{\link{changes}}
   \code{\link{shift_by}}
}
