% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rename.R
\name{rename.corpus}
\alias{rename.corpus}
\alias{rename_with.corpus}
\title{Rename document variables}
\usage{
\method{rename}{corpus}(.data, ...)

\method{rename_with}{corpus}(.data, .fn, .cols = everything(), ...)
}
\arguments{
\item{.data}{a \pkg{quanteda} object with document variables}

\item{...}{For \code{rename()}: <\code{\link[dplyr:dplyr_tidy_select]{tidy-select}}> Use
\code{new_name = old_name} to rename selected variables.

For \code{rename_with()}: additional arguments passed onto \code{.fn}.}

\item{.fn}{A function used to transform the selected \code{.cols}. Should
return a character vector the same length as the input.}

\item{.cols}{<\code{\link[dplyr:dplyr_tidy_select]{tidy-select}}> Columns to rename;
defaults to all columns.}
}
\value{
A corpus with renamed document variables.
}
\description{
\code{rename()} changes the names of individual document variables using \code{new_name = old_name} syntax; \code{rename_with()} renames columns using a function.
}
\examples{
data_corpus_inaugural \%>\%
  rename(LastName = President) \%>\%
  summary(n = 5)
data_corpus_inaugural \%>\%
  rename_with(toupper) \%>\%
  summary(n = 5)
data_corpus_inaugural \%>\%
  rename_with(toupper, starts_with("P")) \%>\%
  summary(n = 5)
}
