% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/max.R
\name{quantile_hotperm}
\alias{quantile_hotperm}
\title{Compute Quantiles for Hotperm Results}
\usage{
quantile_hotperm(x, probs = attr(x, "alpha.levels"), ..., lod.thr = NULL)
}
\arguments{
\item{x}{A `hotperm` object containing permutation test results.}

\item{probs}{A numeric vector of probabilities for quantiles. Defaults to the alpha levels in the object.}

\item{...}{Additional arguments passed to internal functions.}

\item{lod.thr}{LOD threshold for filtering scores. If `NULL`, no filtering is applied.}
}
\value{
A numeric vector or matrix of quantiles, depending on the input parameters.
}
\description{
The `quantile_hotperm` function calculates quantiles for permutation test results.
It is used to summarize the distribution of hotspot sizes and LOD scores.
}
\examples{
\dontrun{
hotperm_obj <- hotperm(cross, n.quant = 300, n.perm = 100, lod.thrs = c(2.5, 3.0))
quantiles <- quantile_hotperm(hotperm_obj, probs = seq(0.1, 0.9, by = 0.1))
}
}
