% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/highlod.R, R/max.R
\name{highlod}
\alias{highlod}
\alias{print.highlod}
\alias{summary.highlod}
\alias{plot.highlod}
\alias{pull.highlod}
\alias{max.highlod}
\title{Pull high LOD values with chr and pos.}
\usage{
highlod(
  scans,
  lod.thr = 0,
  drop.lod = 1.5,
  extend = TRUE,
  restrict.lod = FALSE,
  ...
)

\method{print}{highlod}(x, ...)

\method{summary}{highlod}(object, ...)

\method{plot}{highlod}(x, ..., quant.level = NULL, sliding = FALSE)

pull.highlod(object, chr, pos, ...)

\method{max}{highlod}(x, lod.thr = NULL, window = NULL, quant.level = NULL, ...)
}
\arguments{
\item{scans}{object of class \code{\link[qtl]{scanone}}}

\item{lod.thr}{LOD threshold}

\item{drop.lod}{LOD drop from max to keep for support intervals}

\item{extend}{extend support interval just past \code{drop.lod}; matches
behavior of \code{\link[qtl]{lodint}} when \code{TRUE}}

\item{restrict.lod}{restrict to loci above LOD threshold if \code{TRUE};
matches behavior of \code{\link[qtl]{lodint}} when \code{FALSE} (default)}

\item{\dots}{arguments passed along}

\item{x, object}{object of class \code{highlod}}

\item{quant.level}{vector of LOD levels for 1 up to
\code{length(quant.level)} size hotspots}

\item{sliding}{plot as sliding hotspot if \code{TRUE}}

\item{chr}{chromosome identifier}

\item{pos}{position, or range of positions, in cM}

\item{window}{size of window for smoothing hotspot size}
}
\value{
Data frame with \item{row}{row number in \code{\link[qtl]{scanone}}
object} \item{phenos}{phenotype column number} \item{lod}{LOD score for
phenotype at locus indicated by \code{row}}
}
\description{
Pull high LOD values with chr and pos.
}
\details{
The \code{highlod} condenses a \code{scanone} object to the peaks above a
\code{lod.thr} and/or within \code{drop.lod} of such peaks. The
\code{pull.highlod} pulls out the entries at a particular genomic location
or interval of locations. Summary, print, plot, max and quantile methods
provide ways to examine a \code{highlod} object.
}
\examples{

ncross1 <- sim.null.cross(chr.len = rep(100, 4),
                          n.mar = 51,
                          n.ind = 100,
                          type = "bc",
                          n.phe = 1000,
                          latent.eff = 3,
                          res.var = 1,
                          init.seed = 123457)
cross1 <- include.hotspots(cross = ncross1,
                           hchr = c(2, 3, 4),
                           hpos = c(25, 75, 50),
                           hsize = c(100, 50, 20),
                           Q.eff = 2,
                           latent.eff = 3,
                           lod.range.1 = c(2.5, 2.5),
                           lod.range.2 = c(5, 8),
                           lod.range.3 = c(10, 15),
                           res.var = 1,
                           n.phe = 1000,
                           init.seed = 12345)
scan1 <- scanone(cross1, pheno.col = 1:1000, method = "hk")
high1 <- highlod(scan1, lod.thr = 2.11, drop.lod = 1.5)
pull.highlod(high1, chr = 2, pos = 24)
summary(high1, lod.thr = 2.44)
max(high1, lod.thr = seq(2.11, 3.11, by = .1))

}
\seealso{
\code{\link{highlod}}, \code{\link{hotperm}}
}
\author{
Brian S Yandell and Elias Chaibub Neto
}
\keyword{utilities}
