% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_numeric.R
\name{plot_numeric}
\alias{plot_numeric}
\title{Publication-Quality Numeric Plot with Optional Grouping and Statistical Tests}
\usage{
plot_numeric(
  data,
  var,
  by,
  geom_type = c("bar", "violin", "box", "violin_box", "violin_jitter", "box_jitter"),
  error = c("sd", "se", "ci"),
  test.type = c("auto", "parametric", "nonparametric"),
  vjust = 0,
  rotate = FALSE,
  x.lab = "Group",
  y.lab = NULL,
  text.size = 3.5,
  color.violin = NULL,
  color.box = NULL,
  box.color = "black",
  color.jitter = "black",
  jitter.size = 1.5,
  ptext.size = 3,
  theme_fun = ggthemes::theme_stata,
  bar.width = 0.85,
  box.width = 0.2,
  show.posthoc = TRUE,
  err.mult = 1.5,
  position.p = NULL,
  jitter.width = 0.1
)
}
\arguments{
\item{data}{A data frame containing the variables to plot.}

\item{var}{Numeric variable to plot (unquoted).}

\item{by}{Optional grouping variable (unquoted) to create separate groups.}

\item{geom_type}{Type of plot: "bar", "violin", "box", "violin_box", "violin_jitter", "box_jitter".}

\item{error}{Type of error to display for bar plots: "sd", "se", or "ci".}

\item{test.type}{Statistical test type: "auto", "parametric", or "nonparametric".}

\item{vjust}{Vertical adjustment for text labels. Default is 0.}

\item{rotate}{Logical, whether to rotate x-axis labels. Default is FALSE.}

\item{x.lab}{Label for x-axis. Default is "Group".}

\item{y.lab}{Label for y-axis. Defaults to variable name.}

\item{text.size}{Size of labels above bars or violin/box plots. Default is 3.5.}

\item{color.violin}{Fill color for violin plots. Can be a vector of colors per group.}

\item{color.box}{Fill color for boxplots inside violins. Can be a vector of colors per group.}

\item{box.color}{Outline color for boxplots. Default is "black".}

\item{color.jitter}{Color of jittered points. Default is "black".}

\item{jitter.size}{Size of jittered points. Default is 1.5.}

\item{ptext.size}{Size of text for post-hoc annotations. Default is 3.}

\item{theme_fun}{Theme function from \code{ggthemes} or \code{ggplot2} for styling. Default is \code{ggthemes::theme_stata}.}

\item{bar.width}{Width of bars for bar plots. Default is 0.85.}

\item{box.width}{Width of boxplots inside violin. Default is 0.2.}

\item{show.posthoc}{Logical, whether to display post-hoc test results. Default is TRUE.}

\item{err.mult}{Multiplier for error bars (SD/SE/CI). Default is 1.5.}

\item{position.p}{Optional vector \code{c(x, y)} to place post-hoc text manually.}

\item{jitter.width}{Width of jitter for points in violin_jitter or box_jitter plots. Default is 0.1.}
}
\value{
A \code{ggplot2} object representing the numeric variable plot.
}
\description{
Creates a publication-ready plot for numeric variables, including bar plots, violin plots, boxplots,
and combinations (violin + box, violin + jitter, box + jitter). Supports error bars (SD, SE, CI),
group comparisons, and automatic or specified statistical tests with optional post-hoc annotations.
}
\examples{
# Violin + Box plot for iris dataset
plot_numeric(
  data = iris,
  var = Sepal.Length,
  by = Species,
  geom_type = "violin_box",
  box.width = 0.1,
  color.violin = c("#377eb8", "#ff7f00", "#4daf4a"),
  color.box = c("darkgreen", "#a65628", "#f781bf"),
  box.color = "black",
  color.jitter = "red",
  position.p = c(1,9),
  jitter.size = 2,
  ptext.size = 4,
  show.posthoc = TRUE
)

# Simple bar plot with error bars
plot_numeric(
  data = iris,
  var = Sepal.Length,
  by = Species,
  geom_type = "bar",
  error = "se"
)

# Violin plot with jitter points
plot_numeric(
  data = iris,
  var = Sepal.Length,
  by = Species,
  geom_type = "violin_jitter"
)
}
