% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_functions.R
\name{qq_plot}
\alias{qq_plot}
\title{Quantile-quantile plots against the standard Normal distribution.}
\usage{
qq_plot(data, y, size = 0.7)
}
\arguments{
\item{data}{A data frame.}

\item{y}{A numerical variable in the data frame.}

\item{size}{Size of the marker.}
}
\description{
\code{qq_plot} constructs quantile-quantile plots against the standard normal distribution
(also known as quantile-normal plots).
}
\examples{
data(kfm, package = "ISwR")
require(sjlabelled, quietly = TRUE)
kfm <- kfm |>
  var_labels(
    dl.milk = "Breast-milk intake (dl/day)",
    sex = "Sex",
    weight = "Child weight (kg)",
    ml.suppl = "Milk substitute (ml/day)",
    mat.weight = "Maternal weight (kg)",
    mat.height = "Maternal height (cm)"
  )

kfm |>
  qq_plot(dl.milk)
}
