% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glimpse.R
\name{glimpse.prt}
\alias{glimpse.prt}
\alias{glimpse_dt}
\alias{str_sum}
\alias{str.prt}
\alias{str_dt}
\title{Get a glimpse of your data}
\usage{
\method{glimpse}{prt}(x, width = NULL, ...)

glimpse_dt(x, width = NULL)

str_sum(x)

\method{str}{prt}(object, ...)

str_dt(x, ...)
}
\arguments{
\item{x}{An object to glimpse at.}

\item{width}{Width of output: defaults to the setting of the
\code{width} \link[pillar:pillar_options]{option} (if finite)
or the width of the console.}

\item{...}{Unused, for extensibility.}

\item{object}{any \R object about which you want to have some
    information.}
}
\description{
The \code{tibble} S3 generic function \code{\link[pillar:glimpse]{pillar::glimpse()}} is implemented for
\code{prt} objects as well. Inspired by the output of \code{\link[=str]{str()}} when applied to
\code{data.frames}, this function is intended to display the structure of the
data in terms of columns, irrespective of how the data is organized in terms
of \code{R} objects. Similarly to \code{\link[=format_dt]{format_dt()}}, the function providing the bulk
of functionality, \code{glimpse_dt()}, is exported such that implementing a
class specific \code{\link[pillar:glimpse]{pillar::glimpse()}} function for other classes that
representing tabular data is straightforward.
}
\details{
Alongside a \code{prt}-specific \code{\link[pillar:glimpse]{pillar::glimpse()}} method, a \code{\link[=str]{str()}} method is
provided as well for \code{prt} objects. However, breaking with base \code{R}
expectations, it is not the structure of the object in terms of \code{R} objects
that is shown, but in the same spirit as \code{\link[pillar:glimpse]{pillar::glimpse()}} it is the
structure of the data that is printed. How this data is represents with
respect to \code{R} objects is abstracted away as to show output as would be
expected if the data were represented by a \code{data.frame}.

In similar spirit as \code{\link[=format_dt]{format_dt()}} and \code{glimpse_dt()}, a \code{str_dt()} function
is exported which provides the core functionality driving the \code{prt}
implementation of \code{\link[=str]{str()}}. This function requires availability of a
\code{\link[=head]{head()}} function for any object that is passed and output can be
customized by implementing an optional \code{str_sum()} function.
}
\examples{
cars <- as_prt(mtcars)

pillar::glimpse(cars)
pillar::glimpse(cars, width = 30)

str(cars)
str(cars, vec.len = 1)

str(unclass(cars))

str_sum(cars)

}
